/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.data.utils;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.pig.classification.InterfaceAudience;
import org.apache.pig.data.BinInterSedes;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;

@InterfaceAudience.Private
public class SedesHelper {
    private static final BinInterSedes pigSerializer = new BinInterSedes();
    private static final TupleFactory mTupleFactory = TupleFactory.getInstance();

    public static void writeBytes(DataOutput out, byte[] buf) throws IOException {
        int sz = buf.length;
        if (sz < 255) {
            out.writeByte(13);
            out.writeByte(sz);
        } else if (sz < 65535) {
            out.writeByte(12);
            out.writeShort(sz);
        } else {
            out.writeByte(11);
            out.writeInt(sz);
        }
        out.write(buf);
    }

    public static byte[] readBytes(DataInput in, byte type) throws IOException {
        int sz = 0;
        switch (type) {
            case 13: {
                sz = in.readUnsignedByte();
                break;
            }
            case 12: {
                sz = in.readUnsignedShort();
                break;
            }
            case 11: {
                sz = in.readInt();
            }
        }
        byte[] buf = new byte[sz];
        in.readFully(buf);
        return buf;
    }

    public static void writeChararray(DataOutput out, String s) throws IOException {
        byte[] utfBytes = s.getBytes("UTF-8");
        int length = utfBytes.length;
        if (length < 65535) {
            out.writeByte(15);
            out.writeShort(length);
        } else {
            out.writeByte(14);
            out.writeInt(length);
        }
        out.write(utfBytes);
    }

    public static String readChararray(DataInput in, byte type) throws IOException {
        int size = type == 15 ? in.readUnsignedShort() : in.readInt();
        byte[] buf = new byte[size];
        in.readFully(buf);
        return new String(buf, "UTF-8");
    }

    public static void writeGenericTuple(DataOutput out, Tuple t) throws IOException {
        int sz = t.size();
        switch (sz) {
            case 0: {
                out.writeByte(36);
                break;
            }
            case 1: {
                out.writeByte(37);
                break;
            }
            case 2: {
                out.writeByte(38);
                break;
            }
            case 3: {
                out.writeByte(39);
                break;
            }
            case 4: {
                out.writeByte(40);
                break;
            }
            case 5: {
                out.writeByte(41);
                break;
            }
            case 6: {
                out.writeByte(42);
                break;
            }
            case 7: {
                out.writeByte(43);
                break;
            }
            case 8: {
                out.writeByte(44);
                break;
            }
            case 9: {
                out.writeByte(45);
                break;
            }
            default: {
                if (sz < 255) {
                    out.writeByte(21);
                    out.writeByte(sz);
                    break;
                }
                if (sz < 65535) {
                    out.writeByte(20);
                    out.writeShort(sz);
                    break;
                }
                out.writeByte(19);
                out.writeInt(sz);
            }
        }
        for (int i = 0; i < sz; ++i) {
            pigSerializer.writeDatum(out, t.get(i));
        }
    }

    public static Tuple readGenericTuple(DataInput in, byte type) throws IOException {
        int sz = pigSerializer.getTupleSize(in, type);
        Tuple t = mTupleFactory.newTuple(sz);
        for (int i = 0; i < sz; ++i) {
            t.set(i, pigSerializer.readDatum(in));
        }
        return t;
    }

    public static void writeBooleanArray(DataOutput out, boolean[] v, boolean extra) throws IOException {
        int len = v.length + 1;
        for (int chunk = 0; chunk < len; chunk += 8) {
            int encoding = 0;
            for (int i = chunk; i < len && i < chunk + 8; ++i) {
                encoding = (byte)(encoding << 1);
                encoding = i == v.length ? (int)((byte)(encoding + (extra ? 1 : 0))) : (int)((byte)(encoding + (v[i] ? 1 : 0)));
            }
            out.writeByte(encoding);
        }
    }

    public static void writeBooleanArray(DataOutput out, boolean[] v) throws IOException {
        for (int chunk = 0; chunk < v.length; chunk += 8) {
            int encoding = 0;
            for (int i = chunk; i < v.length && i < chunk + 8; ++i) {
                encoding = (byte)(encoding << 1);
                encoding = (byte)(encoding + (v[i] ? 1 : 0));
            }
            out.writeByte(encoding);
        }
    }

    public static boolean[] readBooleanArray(DataInput in, int size) throws IOException {
        boolean[] v = new boolean[size];
        for (int chunk = 0; chunk < size; chunk += 8) {
            byte decoding = in.readByte();
            for (int i = chunk + Math.min(7, size - chunk - 1); i >= 0; --i) {
                v[i] = decoding % 2 == 1;
                decoding = (byte)(decoding >> 1);
            }
        }
        return v;
    }

    public static class Varint {
        private Varint() {
        }

        public static void writeSignedVarLong(long value, DataOutput out) throws IOException {
            Varint.writeUnsignedVarLong(value << 1 ^ value >> 63, out);
        }

        public static void writeUnsignedVarLong(long value, DataOutput out) throws IOException {
            while ((value & 0xFFFFFFFFFFFFFF80L) != 0L) {
                out.writeByte((int)value & 0x7F | 0x80);
                value >>>= 7;
            }
            out.writeByte((int)value & 0x7F);
        }

        public static void writeSignedVarInt(int value, DataOutput out) throws IOException {
            Varint.writeUnsignedVarInt(value << 1 ^ value >> 31, out);
        }

        public static void writeUnsignedVarInt(int value, DataOutput out) throws IOException {
            while ((long)(value & 0xFFFFFF80) != 0L) {
                out.writeByte(value & 0x7F | 0x80);
                value >>>= 7;
            }
            out.writeByte(value & 0x7F);
        }

        public static long readSignedVarLong(DataInput in) throws IOException {
            long raw = Varint.readUnsignedVarLong(in);
            long temp = (raw << 63 >> 63 ^ raw) >> 1;
            return temp ^ raw & Long.MIN_VALUE;
        }

        public static long readUnsignedVarLong(DataInput in) throws IOException {
            long b;
            long value = 0L;
            int i = 0;
            while (((b = (long)in.readByte()) & 0x80L) != 0L) {
                value |= (b & 0x7FL) << i;
                if ((i += 7) <= 63) continue;
                throw new RuntimeException("Variable length quantity is too long");
            }
            return value | b << i;
        }

        public static int readSignedVarInt(DataInput in) throws IOException {
            int raw = Varint.readUnsignedVarInt(in);
            int temp = (raw << 31 >> 31 ^ raw) >> 1;
            return temp ^ raw & Integer.MIN_VALUE;
        }

        public static int readUnsignedVarInt(DataInput in) throws IOException {
            byte b;
            int value = 0;
            int i = 0;
            while (((b = in.readByte()) & 0x80) != 0) {
                value |= (b & 0x7F) << i;
                if ((i += 7) <= 35) continue;
                throw new RuntimeException("Variable length quantity is too long");
            }
            return value | b << i;
        }
    }
}

