/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;

public class RewindableIterator<E> {
    private Iterator<E> it;
    private ArrayList<E> buf;
    int pos = 0;
    boolean noRewind = false;

    public RewindableIterator(Iterator<E> it) {
        this.it = it;
        this.buf = new ArrayList();
    }

    public boolean hasNext() {
        return this.buf.size() > this.pos || this.it.hasNext();
    }

    public boolean hasNext(int k) {
        for (int need = k - (this.buf.size() - this.pos); need > 0; --need) {
            if (!this.it.hasNext()) {
                return false;
            }
            this.buf.add(this.it.next());
        }
        return true;
    }

    public void rewind() throws IOException {
        if (this.noRewind) {
            throw new IOException("Internal error: attempt to rewind RewindableIterator after rewind has been disabled.");
        }
        this.pos = 0;
    }

    public void noRewind() {
        this.noRewind = true;
        while (this.pos > 0) {
            this.buf.remove(0);
            --this.pos;
        }
    }

    public E next() {
        if (this.noRewind) {
            if (this.buf.size() <= this.pos) {
                return this.it.next();
            }
            return this.buf.remove(this.pos);
        }
        if (this.buf.size() <= this.pos) {
            this.buf.add(this.it.next());
        }
        return this.buf.get(this.pos++);
    }
}

