/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.logical.rules;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.OperatorSubPlan;
import org.apache.pig.newplan.logical.expression.AndExpression;
import org.apache.pig.newplan.logical.expression.LogicalExpression;
import org.apache.pig.newplan.logical.expression.LogicalExpressionPlan;
import org.apache.pig.newplan.logical.expression.ProjectExpression;
import org.apache.pig.newplan.logical.relational.LOFilter;
import org.apache.pig.newplan.logical.relational.LogicalPlan;
import org.apache.pig.newplan.optimizer.Rule;
import org.apache.pig.newplan.optimizer.Transformer;

public class MergeFilter
extends Rule {
    public MergeFilter(String n) {
        super(n, false);
    }

    @Override
    public Transformer getNewTransformer() {
        return new MergeFilterTransformer();
    }

    @Override
    protected OperatorPlan buildPattern() {
        LogicalPlan plan = new LogicalPlan();
        LOFilter op = new LOFilter(plan);
        plan.add(op);
        return plan;
    }

    public class MergeFilterTransformer
    extends Transformer {
        private OperatorSubPlan subPlan;

        @Override
        public boolean check(OperatorPlan matched) throws FrontendException {
            LOFilter filter = (LOFilter)matched.getSources().get(0);
            List<Operator> succeds = MergeFilter.this.currentPlan.getSuccessors(filter);
            return succeds != null && succeds.size() == 1 && succeds.get(0) instanceof LOFilter;
        }

        @Override
        public void transform(OperatorPlan matched) throws FrontendException {
            this.subPlan = new OperatorSubPlan(MergeFilter.this.currentPlan);
            LOFilter filter = (LOFilter)matched.getSources().get(0);
            this.subPlan.add(filter);
            List<Operator> succeds = MergeFilter.this.currentPlan.getSuccessors(filter);
            if (succeds != null && succeds.size() == 1 && succeds.get(0) instanceof LOFilter) {
                LOFilter next = (LOFilter)succeds.get(0);
                this.combineFilterCond(filter, next);
                List<Operator> succs = MergeFilter.this.currentPlan.getSuccessors(next);
                if (succs != null && succs.size() > 0) {
                    this.subPlan.add(succs.get(0));
                }
                ArrayList<Operator> nextSoftPreds = null;
                if (MergeFilter.this.currentPlan.getSoftLinkPredecessors(next) != null) {
                    nextSoftPreds = new ArrayList<Operator>();
                    nextSoftPreds.addAll(MergeFilter.this.currentPlan.getSoftLinkPredecessors(next));
                }
                if (nextSoftPreds != null) {
                    for (Operator softPred : nextSoftPreds) {
                        MergeFilter.this.currentPlan.removeSoftLink(softPred, next);
                        MergeFilter.this.currentPlan.createSoftLink(softPred, filter);
                    }
                }
                MergeFilter.this.currentPlan.removeAndReconnect(next);
            }
            Iterator<Operator> iter = filter.getFilterPlan().getOperators();
            while (iter.hasNext()) {
                Operator oper = iter.next();
                if (!(oper instanceof ProjectExpression)) continue;
                ((ProjectExpression)oper).setAttachedRelationalOp(filter);
            }
        }

        @Override
        public OperatorPlan reportChanges() {
            return this.subPlan;
        }

        private void combineFilterCond(LOFilter f1, LOFilter f2) throws FrontendException {
            List<Operator> l;
            Operator n;
            LogicalExpressionPlan p1 = f1.getFilterPlan();
            LogicalExpressionPlan p2 = f2.getFilterPlan();
            LogicalExpressionPlan andPlan = new LogicalExpressionPlan();
            Iterator<Operator> iter = p1.getOperators();
            while (iter.hasNext()) {
                andPlan.add(iter.next());
            }
            iter = p2.getOperators();
            while (iter.hasNext()) {
                andPlan.add(iter.next());
            }
            iter = p1.getOperators();
            while (iter.hasNext()) {
                n = iter.next();
                l = p1.getPredecessors(n);
                if (l == null) continue;
                for (Operator op : l) {
                    andPlan.connect(op, n);
                }
            }
            iter = p2.getOperators();
            while (iter.hasNext()) {
                n = iter.next();
                l = p2.getPredecessors(n);
                if (l == null) continue;
                for (Operator op : l) {
                    andPlan.connect(op, n);
                }
            }
            new AndExpression(andPlan, (LogicalExpression)p1.getSources().get(0), (LogicalExpression)p2.getSources().get(0));
            f1.setFilterPlan(andPlan);
        }
    }
}

