/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink;

import com.google.crypto.tink.Aead;
import com.google.crypto.tink.InsecureSecretKeyAccess;
import com.google.crypto.tink.Key;
import com.google.crypto.tink.KeyStatus;
import com.google.crypto.tink.KeysetManager;
import com.google.crypto.tink.KeysetReader;
import com.google.crypto.tink.KeysetWriter;
import com.google.crypto.tink.Parameters;
import com.google.crypto.tink.PrimitiveSet;
import com.google.crypto.tink.Registry;
import com.google.crypto.tink.Util;
import com.google.crypto.tink.annotations.Alpha;
import com.google.crypto.tink.internal.LegacyProtoKey;
import com.google.crypto.tink.internal.LegacyProtoParameters;
import com.google.crypto.tink.internal.MutableSerializationRegistry;
import com.google.crypto.tink.internal.ProtoKeySerialization;
import com.google.crypto.tink.internal.ProtoParametersSerialization;
import com.google.crypto.tink.internal.TinkBugException;
import com.google.crypto.tink.monitoring.MonitoringAnnotations;
import com.google.crypto.tink.proto.EncryptedKeyset;
import com.google.crypto.tink.proto.KeyData;
import com.google.crypto.tink.proto.KeyStatusType;
import com.google.crypto.tink.proto.KeyTemplate;
import com.google.crypto.tink.proto.Keyset;
import com.google.crypto.tink.proto.KeysetInfo;
import com.google.crypto.tink.proto.OutputPrefixType;
import com.google.crypto.tink.tinkkey.KeyAccess;
import com.google.crypto.tink.tinkkey.KeyHandle;
import com.google.crypto.tink.tinkkey.TinkKey;
import com.google.crypto.tink.tinkkey.internal.InternalKeyHandle;
import com.google.crypto.tink.tinkkey.internal.ProtoKey;
import com.google.errorprone.annotations.Immutable;
import com.google.protobuf.ByteString;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;

public final class KeysetHandle {
    private final Keyset keyset;
    private final MonitoringAnnotations annotations;

    private static KeyStatus parseStatus(KeyStatusType in) throws GeneralSecurityException {
        switch (in) {
            case ENABLED: {
                return KeyStatus.ENABLED;
            }
            case DISABLED: {
                return KeyStatus.DISABLED;
            }
            case DESTROYED: {
                return KeyStatus.DESTROYED;
            }
        }
        throw new GeneralSecurityException("Unknown key status");
    }

    private static KeyStatusType serializeStatus(KeyStatus in) {
        if (KeyStatus.ENABLED.equals(in)) {
            return KeyStatusType.ENABLED;
        }
        if (KeyStatus.DISABLED.equals(in)) {
            return KeyStatusType.DISABLED;
        }
        if (KeyStatus.DESTROYED.equals(in)) {
            return KeyStatusType.DESTROYED;
        }
        throw new IllegalStateException("Unknown key status");
    }

    private static Keyset.Key toKeysetKey(int id, KeyStatusType status, ProtoKeySerialization protoKeySerialization) {
        return Keyset.Key.newBuilder().setKeyData(KeyData.newBuilder().setTypeUrl(protoKeySerialization.getTypeUrl()).setValue(protoKeySerialization.getValue()).setKeyMaterialType(protoKeySerialization.getKeyMaterialType())).setStatus(status).setKeyId(id).setOutputPrefixType(protoKeySerialization.getOutputPrefixType()).build();
    }

    static ProtoKeySerialization toProtoKeySerialization(Keyset.Key protoKey) {
        int id = protoKey.getKeyId();
        Integer idRequirement = protoKey.getOutputPrefixType() == OutputPrefixType.RAW ? null : Integer.valueOf(id);
        try {
            return ProtoKeySerialization.create(protoKey.getKeyData().getTypeUrl(), protoKey.getKeyData().getValue(), protoKey.getKeyData().getKeyMaterialType(), protoKey.getOutputPrefixType(), idRequirement);
        }
        catch (GeneralSecurityException e) {
            throw new TinkBugException("Creating a protokey serialization failed", e);
        }
    }

    private Entry entryByIndex(int i) {
        Keyset.Key protoKey = this.keyset.getKey(i);
        int id = protoKey.getKeyId();
        ProtoKeySerialization protoKeySerialization = KeysetHandle.toProtoKeySerialization(protoKey);
        Key key = MutableSerializationRegistry.globalInstance().parseKeyWithLegacyFallback(protoKeySerialization, InsecureSecretKeyAccess.get());
        try {
            return new Entry(key, KeysetHandle.parseStatus(protoKey.getStatus()), id, id == this.keyset.getPrimaryKeyId());
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException("Creating an entry failed", e);
        }
    }

    public static Builder.Entry importKey(Key key) {
        Builder.Entry importedEntry = new Builder.Entry(key);
        Integer requirement = key.getIdRequirementOrNull();
        if (requirement != null) {
            importedEntry.withFixedId(requirement);
        }
        return importedEntry;
    }

    public static Builder.Entry generateEntryFromParametersName(String namedParameters) throws GeneralSecurityException {
        if (!Registry.keyTemplateMap().containsKey(namedParameters)) {
            throw new GeneralSecurityException("cannot find key template: " + namedParameters);
        }
        com.google.crypto.tink.KeyTemplate template = Registry.keyTemplateMap().get(namedParameters);
        ProtoParametersSerialization serialization = ProtoParametersSerialization.create(template.getProto());
        Parameters parameters = MutableSerializationRegistry.globalInstance().parseParametersWithLegacyFallback(serialization);
        return new Builder.Entry(parameters);
    }

    public static Builder.Entry generateEntryFromParameters(Parameters parameters) {
        return new Builder.Entry(parameters);
    }

    private KeysetHandle(Keyset keyset) {
        this.keyset = keyset;
        this.annotations = MonitoringAnnotations.EMPTY;
    }

    private KeysetHandle(Keyset keyset, MonitoringAnnotations annotations) {
        this.keyset = keyset;
        this.annotations = annotations;
    }

    static final KeysetHandle fromKeyset(Keyset keyset) throws GeneralSecurityException {
        KeysetHandle.assertEnoughKeyMaterial(keyset);
        return new KeysetHandle(keyset);
    }

    static final KeysetHandle fromKeysetAndAnnotations(Keyset keyset, MonitoringAnnotations annotations) throws GeneralSecurityException {
        KeysetHandle.assertEnoughKeyMaterial(keyset);
        return new KeysetHandle(keyset, annotations);
    }

    Keyset getKeyset() {
        return this.keyset;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(KeysetHandle handle) {
        Builder builder = new Builder();
        for (int i = 0; i < handle.size(); ++i) {
            Entry entry = handle.entryByIndex(i);
            Builder.Entry builderEntry = KeysetHandle.importKey(entry.getKey()).withFixedId(entry.getId());
            builderEntry.setStatus(entry.getStatus());
            if (entry.isPrimary()) {
                builderEntry.makePrimary();
            }
            builder.addEntry(builderEntry);
        }
        return builder;
    }

    public Entry getPrimary() {
        for (int i = 0; i < this.keyset.getKeyCount(); ++i) {
            if (this.keyset.getKey(i).getKeyId() != this.keyset.getPrimaryKeyId()) continue;
            Entry result = this.entryByIndex(i);
            if (result.getStatus() != KeyStatus.ENABLED) {
                throw new IllegalStateException("Keyset has primary which isn't enabled");
            }
            return result;
        }
        throw new IllegalStateException("Keyset has no primary");
    }

    public int size() {
        return this.keyset.getKeyCount();
    }

    public Entry getAt(int i) {
        if (i < 0 || i >= this.size()) {
            throw new IndexOutOfBoundsException("Invalid index " + i + " for keyset of size " + this.size());
        }
        return this.entryByIndex(i);
    }

    public List<KeyHandle> getKeys() {
        ArrayList<InternalKeyHandle> result = new ArrayList<InternalKeyHandle>();
        for (Keyset.Key key : this.keyset.getKeyList()) {
            KeyData keyData = key.getKeyData();
            result.add(new InternalKeyHandle((TinkKey)new ProtoKey(keyData, com.google.crypto.tink.KeyTemplate.fromProto(key.getOutputPrefixType())), key.getStatus(), key.getKeyId()));
        }
        return Collections.unmodifiableList(result);
    }

    public KeysetInfo getKeysetInfo() {
        return Util.getKeysetInfo(this.keyset);
    }

    @Deprecated
    public static final KeysetHandle generateNew(KeyTemplate keyTemplate) throws GeneralSecurityException {
        return KeysetManager.withEmptyKeyset().rotate(keyTemplate).getKeysetHandle();
    }

    public static final KeysetHandle generateNew(com.google.crypto.tink.KeyTemplate keyTemplate) throws GeneralSecurityException {
        return KeysetManager.withEmptyKeyset().rotate(keyTemplate.getProto()).getKeysetHandle();
    }

    @Deprecated
    public static final KeysetHandle createFromKey(KeyHandle keyHandle, KeyAccess access) throws GeneralSecurityException {
        KeysetManager km = KeysetManager.withEmptyKeyset().add(keyHandle);
        km.setPrimary(km.getKeysetHandle().getKeysetInfo().getKeyInfo(0).getKeyId());
        return km.getKeysetHandle();
    }

    public static final KeysetHandle read(KeysetReader reader, Aead masterKey) throws GeneralSecurityException, IOException {
        return KeysetHandle.readWithAssociatedData(reader, masterKey, new byte[0]);
    }

    public static final KeysetHandle readWithAssociatedData(KeysetReader reader, Aead masterKey, byte[] associatedData) throws GeneralSecurityException, IOException {
        EncryptedKeyset encryptedKeyset = reader.readEncrypted();
        KeysetHandle.assertEnoughEncryptedKeyMaterial(encryptedKeyset);
        return new KeysetHandle(KeysetHandle.decrypt(encryptedKeyset, masterKey, associatedData));
    }

    public static final KeysetHandle readNoSecret(KeysetReader reader) throws GeneralSecurityException, IOException {
        try {
            Keyset keyset = reader.read();
            KeysetHandle.assertNoSecretKeyMaterial(keyset);
            return KeysetHandle.fromKeyset(keyset);
        }
        catch (InvalidProtocolBufferException e) {
            throw new GeneralSecurityException("invalid keyset");
        }
    }

    public static final KeysetHandle readNoSecret(byte[] serialized) throws GeneralSecurityException {
        try {
            Keyset keyset = Keyset.parseFrom(serialized, ExtensionRegistryLite.getEmptyRegistry());
            KeysetHandle.assertNoSecretKeyMaterial(keyset);
            return KeysetHandle.fromKeyset(keyset);
        }
        catch (InvalidProtocolBufferException e) {
            throw new GeneralSecurityException("invalid keyset");
        }
    }

    public void write(KeysetWriter keysetWriter, Aead masterKey) throws GeneralSecurityException, IOException {
        this.writeWithAssociatedData(keysetWriter, masterKey, new byte[0]);
    }

    public void writeWithAssociatedData(KeysetWriter keysetWriter, Aead masterKey, byte[] associatedData) throws GeneralSecurityException, IOException {
        EncryptedKeyset encryptedKeyset = KeysetHandle.encrypt(this.keyset, masterKey, associatedData);
        keysetWriter.write(encryptedKeyset);
    }

    public void writeNoSecret(KeysetWriter writer) throws GeneralSecurityException, IOException {
        KeysetHandle.assertNoSecretKeyMaterial(this.keyset);
        writer.write(this.keyset);
    }

    private static EncryptedKeyset encrypt(Keyset keyset, Aead masterKey, byte[] associatedData) throws GeneralSecurityException {
        byte[] encryptedKeyset = masterKey.encrypt(keyset.toByteArray(), associatedData);
        try {
            Keyset keyset2 = Keyset.parseFrom(masterKey.decrypt(encryptedKeyset, associatedData), ExtensionRegistryLite.getEmptyRegistry());
            if (!keyset2.equals(keyset)) {
                throw new GeneralSecurityException("cannot encrypt keyset");
            }
        }
        catch (InvalidProtocolBufferException e) {
            throw new GeneralSecurityException("invalid keyset, corrupted key material");
        }
        return EncryptedKeyset.newBuilder().setEncryptedKeyset(ByteString.copyFrom((byte[])encryptedKeyset)).setKeysetInfo(Util.getKeysetInfo(keyset)).build();
    }

    private static Keyset decrypt(EncryptedKeyset encryptedKeyset, Aead masterKey, byte[] associatedData) throws GeneralSecurityException {
        try {
            Keyset keyset = Keyset.parseFrom(masterKey.decrypt(encryptedKeyset.getEncryptedKeyset().toByteArray(), associatedData), ExtensionRegistryLite.getEmptyRegistry());
            KeysetHandle.assertEnoughKeyMaterial(keyset);
            return keyset;
        }
        catch (InvalidProtocolBufferException e) {
            throw new GeneralSecurityException("invalid keyset, corrupted key material");
        }
    }

    public KeysetHandle getPublicKeysetHandle() throws GeneralSecurityException {
        if (this.keyset == null) {
            throw new GeneralSecurityException("cleartext keyset is not available");
        }
        Keyset.Builder keysetBuilder = Keyset.newBuilder();
        for (Keyset.Key key : this.keyset.getKeyList()) {
            KeyData keyData = KeysetHandle.createPublicKeyData(key.getKeyData());
            keysetBuilder.addKey(key.toBuilder().setKeyData(keyData).build());
        }
        keysetBuilder.setPrimaryKeyId(this.keyset.getPrimaryKeyId());
        return new KeysetHandle(keysetBuilder.build());
    }

    private static KeyData createPublicKeyData(KeyData privateKeyData) throws GeneralSecurityException {
        if (privateKeyData.getKeyMaterialType() != KeyData.KeyMaterialType.ASYMMETRIC_PRIVATE) {
            throw new GeneralSecurityException("The keyset contains a non-private key");
        }
        KeyData publicKeyData = Registry.getPublicKeyData(privateKeyData.getTypeUrl(), privateKeyData.getValue());
        KeysetHandle.validate(publicKeyData);
        return publicKeyData;
    }

    private static void validate(KeyData keyData) throws GeneralSecurityException {
        Registry.getPrimitive(keyData);
    }

    public String toString() {
        return this.getKeysetInfo().toString();
    }

    private static void assertNoSecretKeyMaterial(Keyset keyset) throws GeneralSecurityException {
        for (Keyset.Key key : keyset.getKeyList()) {
            if (key.getKeyData().getKeyMaterialType() != KeyData.KeyMaterialType.UNKNOWN_KEYMATERIAL && key.getKeyData().getKeyMaterialType() != KeyData.KeyMaterialType.SYMMETRIC && key.getKeyData().getKeyMaterialType() != KeyData.KeyMaterialType.ASYMMETRIC_PRIVATE) continue;
            throw new GeneralSecurityException(String.format("keyset contains key material of type %s for type url %s", key.getKeyData().getKeyMaterialType().name(), key.getKeyData().getTypeUrl()));
        }
    }

    private static void assertEnoughKeyMaterial(Keyset keyset) throws GeneralSecurityException {
        if (keyset == null || keyset.getKeyCount() <= 0) {
            throw new GeneralSecurityException("empty keyset");
        }
    }

    private static void assertEnoughEncryptedKeyMaterial(EncryptedKeyset keyset) throws GeneralSecurityException {
        if (keyset == null || keyset.getEncryptedKeyset().size() == 0) {
            throw new GeneralSecurityException("empty keyset");
        }
    }

    private <B, P> P getPrimitiveWithKnownInputPrimitive(Class<P> classObject, Class<B> inputPrimitiveClassObject) throws GeneralSecurityException {
        Util.validateKeyset(this.keyset);
        PrimitiveSet.Builder<B> builder = PrimitiveSet.newBuilder(inputPrimitiveClassObject);
        builder.setAnnotations(this.annotations);
        for (Keyset.Key key : this.keyset.getKeyList()) {
            if (key.getStatus() != KeyStatusType.ENABLED) continue;
            B primitive = Registry.getPrimitive(key.getKeyData(), inputPrimitiveClassObject);
            if (key.getKeyId() == this.keyset.getPrimaryKeyId()) {
                builder.addPrimaryPrimitive(primitive, key);
                continue;
            }
            builder.addPrimitive(primitive, key);
        }
        return Registry.wrap(builder.build(), classObject);
    }

    public <P> P getPrimitive(Class<P> targetClassObject) throws GeneralSecurityException {
        Class<?> inputPrimitiveClassObject = Registry.getInputPrimitive(targetClassObject);
        if (inputPrimitiveClassObject == null) {
            throw new GeneralSecurityException("No wrapper found for " + targetClassObject.getName());
        }
        return this.getPrimitiveWithKnownInputPrimitive(targetClassObject, inputPrimitiveClassObject);
    }

    public KeyHandle primaryKey() throws GeneralSecurityException {
        int primaryKeyId = this.keyset.getPrimaryKeyId();
        for (Keyset.Key key : this.keyset.getKeyList()) {
            if (key.getKeyId() != primaryKeyId) continue;
            return new InternalKeyHandle((TinkKey)new ProtoKey(key.getKeyData(), com.google.crypto.tink.KeyTemplate.fromProto(key.getOutputPrefixType())), key.getStatus(), key.getKeyId());
        }
        throw new GeneralSecurityException("No primary key found in keyset.");
    }

    @Immutable
    @Alpha
    public static final class Entry {
        private final Key key;
        private final KeyStatus keyStatus;
        private final int id;
        private final boolean isPrimary;

        private Entry(Key key, KeyStatus keyStatus, int id, boolean isPrimary) {
            this.key = key;
            this.keyStatus = keyStatus;
            this.id = id;
            this.isPrimary = isPrimary;
        }

        public Key getKey() {
            return this.key;
        }

        public KeyStatus getStatus() {
            return this.keyStatus;
        }

        public int getId() {
            return this.id;
        }

        public boolean isPrimary() {
            return this.isPrimary;
        }
    }

    public static final class Builder {
        private final List<Entry> entries = new ArrayList<Entry>();

        private void clearPrimary() {
            for (Entry entry : this.entries) {
                entry.isPrimary = false;
            }
        }

        public Builder addEntry(Entry entry) {
            if (entry.builder != null) {
                throw new IllegalStateException("Entry has already been added to a KeysetHandle.Builder");
            }
            if (entry.isPrimary) {
                this.clearPrimary();
            }
            entry.builder = this;
            this.entries.add(entry);
            return this;
        }

        public int size() {
            return this.entries.size();
        }

        public Entry getAt(int i) {
            return this.entries.get(i);
        }

        public Entry removeAt(int i) {
            return this.entries.remove(i);
        }

        private static void checkIdAssignments(List<Entry> entries) throws GeneralSecurityException {
            for (int i = 0; i < entries.size() - 1; ++i) {
                if (entries.get(i).strategy != KeyIdStrategy.RANDOM_ID || entries.get(i + 1).strategy == KeyIdStrategy.RANDOM_ID) continue;
                throw new GeneralSecurityException("Entries with 'withRandomId()' may only be followed by other entries with 'withRandomId()'.");
            }
        }

        private static int randomIdNotInSet(Set<Integer> ids) {
            int id = 0;
            while (id == 0 || ids.contains(id)) {
                id = com.google.crypto.tink.internal.Util.randKeyId();
            }
            return id;
        }

        private static Keyset.Key createKeyFromParameters(Parameters parameters, int id, KeyStatusType keyStatusType) throws GeneralSecurityException {
            ProtoParametersSerialization serializedParameters = parameters instanceof LegacyProtoParameters ? ((LegacyProtoParameters)parameters).getSerialization() : MutableSerializationRegistry.globalInstance().serializeParameters(parameters, ProtoParametersSerialization.class);
            KeyData keyData = Registry.newKeyData(serializedParameters.getKeyTemplate());
            return Keyset.Key.newBuilder().setKeyId(id).setStatus(keyStatusType).setKeyData(keyData).setOutputPrefixType(serializedParameters.getKeyTemplate().getOutputPrefixType()).build();
        }

        private static int getNextIdFromBuilderEntry(Entry builderEntry, Set<Integer> idsSoFar) throws GeneralSecurityException {
            int id = 0;
            if (builderEntry.strategy == null) {
                throw new GeneralSecurityException("No ID was set (with withFixedId or withRandomId)");
            }
            id = builderEntry.strategy == KeyIdStrategy.RANDOM_ID ? Builder.randomIdNotInSet(idsSoFar) : builderEntry.strategy.getFixedId();
            return id;
        }

        private static Keyset.Key createKeysetKeyFromBuilderEntry(Entry builderEntry, int id) throws GeneralSecurityException {
            if (builderEntry.key == null) {
                return Builder.createKeyFromParameters(builderEntry.parameters, id, KeysetHandle.serializeStatus(builderEntry.getStatus()));
            }
            ProtoKeySerialization serializedKey = builderEntry.key instanceof LegacyProtoKey ? ((LegacyProtoKey)builderEntry.key).getSerialization(InsecureSecretKeyAccess.get()) : MutableSerializationRegistry.globalInstance().serializeKey(builderEntry.key, ProtoKeySerialization.class, InsecureSecretKeyAccess.get());
            Integer idRequirement = serializedKey.getIdRequirementOrNull();
            if (idRequirement != null && idRequirement != id) {
                throw new GeneralSecurityException("Wrong ID set for key with ID requirement");
            }
            return KeysetHandle.toKeysetKey(id, KeysetHandle.serializeStatus(builderEntry.getStatus()), serializedKey);
        }

        public KeysetHandle build() throws GeneralSecurityException {
            Keyset.Builder keysetBuilder = Keyset.newBuilder();
            Integer primaryId = null;
            Builder.checkIdAssignments(this.entries);
            HashSet<Integer> idsSoFar = new HashSet<Integer>();
            for (Entry builderEntry : this.entries) {
                if (builderEntry.keyStatus == null) {
                    throw new GeneralSecurityException("Key Status not set.");
                }
                int id = Builder.getNextIdFromBuilderEntry(builderEntry, idsSoFar);
                if (idsSoFar.contains(id)) {
                    throw new GeneralSecurityException("Id " + id + " is used twice in the keyset");
                }
                idsSoFar.add(id);
                Keyset.Key keysetKey = Builder.createKeysetKeyFromBuilderEntry(builderEntry, id);
                keysetBuilder.addKey(keysetKey);
                if (!builderEntry.isPrimary) continue;
                if (primaryId != null) {
                    throw new GeneralSecurityException("Two primaries were set");
                }
                primaryId = id;
            }
            if (primaryId == null) {
                throw new GeneralSecurityException("No primary was set");
            }
            keysetBuilder.setPrimaryKeyId(primaryId);
            return new KeysetHandle(keysetBuilder.build());
        }

        public static final class Entry {
            private boolean isPrimary;
            private KeyStatus keyStatus = KeyStatus.ENABLED;
            @Nullable
            private final Key key;
            @Nullable
            private final Parameters parameters;
            private KeyIdStrategy strategy = null;
            @Nullable
            private Builder builder = null;

            private Entry(Key key) {
                this.key = key;
                this.parameters = null;
            }

            private Entry(Parameters parameters) {
                this.key = null;
                this.parameters = parameters;
            }

            public Entry makePrimary() {
                if (this.builder != null) {
                    this.builder.clearPrimary();
                }
                this.isPrimary = true;
                return this;
            }

            public boolean isPrimary() {
                return this.isPrimary;
            }

            public Entry setStatus(KeyStatus status) {
                this.keyStatus = status;
                return this;
            }

            public KeyStatus getStatus() {
                return this.keyStatus;
            }

            public Entry withFixedId(int id) {
                this.strategy = KeyIdStrategy.fixedId(id);
                return this;
            }

            public Entry withRandomId() {
                this.strategy = KeyIdStrategy.randomId();
                return this;
            }
        }

        private static class KeyIdStrategy {
            private static final KeyIdStrategy RANDOM_ID = new KeyIdStrategy();
            private final int fixedId;

            private KeyIdStrategy() {
                this.fixedId = 0;
            }

            private KeyIdStrategy(int id) {
                this.fixedId = id;
            }

            private static KeyIdStrategy randomId() {
                return RANDOM_ID;
            }

            private static KeyIdStrategy fixedId(int id) {
                return new KeyIdStrategy(id);
            }

            private int getFixedId() {
                return this.fixedId;
            }
        }
    }
}

