/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.jwt;

import com.google.crypto.tink.jwt.JwtInvalidException;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;

final class JsonUtil {
    static boolean isValidString(String s) {
        int length = s.length();
        int i = 0;
        while (i != length) {
            char ch = s.charAt(i);
            ++i;
            if (!Character.isSurrogate(ch)) continue;
            if (Character.isLowSurrogate(ch) || i == length || !Character.isLowSurrogate(s.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static void validateAllStringsInJsonObject(JsonObject jsonObject) throws JwtInvalidException {
        for (Map.Entry entry : jsonObject.entrySet()) {
            if (!JsonUtil.isValidString((String)entry.getKey())) {
                throw new JwtInvalidException("JSON string contains character");
            }
            JsonUtil.validateAllStringsInJsonElement((JsonElement)entry.getValue());
        }
    }

    private static void validateAllStringsInJsonElement(JsonElement element) throws JwtInvalidException {
        if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isString()) {
            if (!JsonUtil.isValidString(element.getAsJsonPrimitive().getAsString())) {
                throw new JwtInvalidException("JSON string contains invalid character");
            }
        } else if (element.isJsonObject()) {
            JsonUtil.validateAllStringsInJsonObject(element.getAsJsonObject());
        } else if (element.isJsonArray()) {
            JsonUtil.validateAllStringsInJsonArray(element.getAsJsonArray());
        }
    }

    private static void validateAllStringsInJsonArray(JsonArray jsonArray) throws JwtInvalidException {
        for (JsonElement element : jsonArray) {
            JsonUtil.validateAllStringsInJsonElement(element);
        }
    }

    static JsonObject parseJson(String jsonString) throws JwtInvalidException {
        try {
            JsonReader jsonReader = new JsonReader((Reader)new StringReader(jsonString));
            jsonReader.setLenient(false);
            JsonObject output = Streams.parse((JsonReader)jsonReader).getAsJsonObject();
            JsonUtil.validateAllStringsInJsonObject(output);
            return output;
        }
        catch (JsonParseException | IllegalStateException | StackOverflowError ex) {
            throw new JwtInvalidException("invalid JSON: " + ex);
        }
    }

    static JsonArray parseJsonArray(String jsonString) throws JwtInvalidException {
        try {
            JsonReader jsonReader = new JsonReader((Reader)new StringReader(jsonString));
            jsonReader.setLenient(false);
            JsonArray output = Streams.parse((JsonReader)jsonReader).getAsJsonArray();
            JsonUtil.validateAllStringsInJsonArray(output);
            return output;
        }
        catch (JsonParseException | IllegalStateException | StackOverflowError ex) {
            throw new JwtInvalidException("invalid JSON: " + ex);
        }
    }

    private JsonUtil() {
    }
}

