/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.examples.terasort;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.examples.terasort.TeraOutputFormat;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class TeraGen
extends Configured
implements Tool {
    static long getNumberOfRows(JobConf job) {
        return job.getLong("terasort.num-rows", 0L);
    }

    static void setNumberOfRows(JobConf job, long numRows) {
        job.setLong("terasort.num-rows", numRows);
    }

    public int run(String[] args) throws IOException {
        JobConf job = (JobConf)this.getConf();
        TeraGen.setNumberOfRows(job, Long.parseLong(args[0]));
        FileOutputFormat.setOutputPath((JobConf)job, (Path)new Path(args[1]));
        job.setJobName("TeraGen");
        job.setJarByClass(TeraGen.class);
        job.setMapperClass(SortGenMapper.class);
        job.setNumReduceTasks(0);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(Text.class);
        job.setInputFormat(RangeInputFormat.class);
        job.setOutputFormat(TeraOutputFormat.class);
        JobClient.runJob((JobConf)job);
        return 0;
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Configuration)new JobConf(), (Tool)new TeraGen(), (String[])args);
        System.exit(res);
    }

    public static class SortGenMapper
    extends MapReduceBase
    implements Mapper<LongWritable, NullWritable, Text, Text> {
        private Text key = new Text();
        private Text value = new Text();
        private RandomGenerator rand;
        private byte[] keyBytes = new byte[12];
        private byte[] spaces = "          ".getBytes();
        private byte[][] filler = new byte[26][];

        public SortGenMapper() {
            for (int i = 0; i < 26; ++i) {
                this.filler[i] = new byte[10];
                for (int j = 0; j < 10; ++j) {
                    this.filler[i][j] = (byte)(65 + i);
                }
            }
        }

        private void addKey() {
            for (int i = 0; i < 3; ++i) {
                long temp = this.rand.next() / 52L;
                this.keyBytes[3 + 4 * i] = (byte)(32L + temp % 95L);
                this.keyBytes[2 + 4 * i] = (byte)(32L + (temp /= 95L) % 95L);
                this.keyBytes[1 + 4 * i] = (byte)(32L + (temp /= 95L) % 95L);
                this.keyBytes[4 * i] = (byte)(32L + (temp /= 95L) % 95L);
            }
            this.key.set(this.keyBytes, 0, 10);
        }

        private void addRowId(long rowId) {
            byte[] rowid = Integer.toString((int)rowId).getBytes();
            int padSpace = 10 - rowid.length;
            if (padSpace > 0) {
                this.value.append(this.spaces, 0, 10 - rowid.length);
            }
            this.value.append(rowid, 0, Math.min(rowid.length, 10));
        }

        private void addFiller(long rowId) {
            int base = (int)(rowId * 8L % 26L);
            for (int i = 0; i < 7; ++i) {
                this.value.append(this.filler[(base + i) % 26], 0, 10);
            }
            this.value.append(this.filler[(base + 7) % 26], 0, 8);
        }

        public void map(LongWritable row, NullWritable ignored, OutputCollector<Text, Text> output, Reporter reporter) throws IOException {
            long rowId = row.get();
            if (this.rand == null) {
                this.rand = new RandomGenerator(rowId * 3L);
            }
            this.addKey();
            this.value.clear();
            this.addRowId(rowId);
            this.addFiller(rowId);
            output.collect((Object)this.key, (Object)this.value);
        }
    }

    static class RandomGenerator {
        private long seed = 0L;
        private static final long mask32 = 0xFFFFFFFFL;
        private static final int seedSkip = 0x8000000;
        private static final long[] seeds = new long[]{0L, 0xF8000000L, 0xF0000000L, 0xE8000000L, 0xE0000000L, 0xD8000000L, 0xD0000000L, 0xC8000000L, 0xC0000000L, 0xB8000000L, 0xB0000000L, 0xA8000000L, 0xA0000000L, 0x98000000L, 0x90000000L, 0x88000000L, 0x80000000L, 0x78000000L, 0x70000000L, 0x68000000L, 0x60000000L, 0x58000000L, 0x50000000L, 0x48000000L, 0x40000000L, 0x38000000L, 0x30000000L, 0x28000000L, 0x20000000L, 0x18000000L, 0x10000000L, 0x8000000L};

        RandomGenerator(long initalIteration) {
            int baseIndex = (int)((initalIteration & 0xFFFFFFFFL) / 0x8000000L);
            this.seed = seeds[baseIndex];
            int i = 0;
            while ((long)i < initalIteration % 0x8000000L) {
                this.next();
                ++i;
            }
        }

        RandomGenerator() {
            this(0L);
        }

        long next() {
            this.seed = this.seed * 3141592621L + 663896637L & 0xFFFFFFFFL;
            return this.seed;
        }
    }

    static class RangeInputFormat
    implements InputFormat<LongWritable, NullWritable> {
        RangeInputFormat() {
        }

        public RecordReader<LongWritable, NullWritable> getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
            return new RangeRecordReader((RangeInputSplit)split);
        }

        public InputSplit[] getSplits(JobConf job, int numSplits) {
            long totalRows = TeraGen.getNumberOfRows(job);
            long rowsPerSplit = totalRows / (long)numSplits;
            System.out.println("Generating " + totalRows + " using " + numSplits + " maps with step of " + rowsPerSplit);
            InputSplit[] splits = new InputSplit[numSplits];
            long currentRow = 0L;
            for (int split = 0; split < numSplits - 1; ++split) {
                splits[split] = new RangeInputSplit(currentRow, rowsPerSplit);
                currentRow += rowsPerSplit;
            }
            splits[numSplits - 1] = new RangeInputSplit(currentRow, totalRows - currentRow);
            return splits;
        }

        static class RangeRecordReader
        implements RecordReader<LongWritable, NullWritable> {
            long startRow;
            long finishedRows;
            long totalRows;

            public RangeRecordReader(RangeInputSplit split) {
                this.startRow = split.firstRow;
                this.finishedRows = 0L;
                this.totalRows = split.rowCount;
            }

            public void close() throws IOException {
            }

            public LongWritable createKey() {
                return new LongWritable();
            }

            public NullWritable createValue() {
                return NullWritable.get();
            }

            public long getPos() throws IOException {
                return this.finishedRows;
            }

            public float getProgress() throws IOException {
                return (float)this.finishedRows / (float)this.totalRows;
            }

            public boolean next(LongWritable key, NullWritable value) {
                if (this.finishedRows < this.totalRows) {
                    key.set(this.startRow + this.finishedRows);
                    ++this.finishedRows;
                    return true;
                }
                return false;
            }
        }

        static class RangeInputSplit
        implements InputSplit {
            long firstRow;
            long rowCount;

            public RangeInputSplit() {
            }

            public RangeInputSplit(long offset, long length) {
                this.firstRow = offset;
                this.rowCount = length;
            }

            public long getLength() throws IOException {
                return 0L;
            }

            public String[] getLocations() throws IOException {
                return new String[0];
            }

            public void readFields(DataInput in) throws IOException {
                this.firstRow = WritableUtils.readVLong((DataInput)in);
                this.rowCount = WritableUtils.readVLong((DataInput)in);
            }

            public void write(DataOutput out) throws IOException {
                WritableUtils.writeVLong((DataOutput)out, (long)this.firstRow);
                WritableUtils.writeVLong((DataOutput)out, (long)this.rowCount);
            }
        }
    }
}

