/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ImmutableHRegionInfo;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={ClientTests.class, SmallTests.class})
public class TestImmutableHRegionInfo {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestImmutableHRegionInfo.class);
    @Rule
    public TestName name = new TestName();
    private final List<Consumer<ImmutableHRegionInfo>> TEST_FUNCTIONS = Arrays.asList(hri -> hri.setOffline(true), hri -> hri.setSplit(true));

    @Test
    public void testImmutable() {
        HRegionInfo hri = new HRegionInfo(TableName.valueOf((String)this.name.getMethodName()));
        ImmutableHRegionInfo immutableHri = new ImmutableHRegionInfo((RegionInfo)hri);
        this.TEST_FUNCTIONS.forEach(f -> {
            try {
                f.accept(immutableHri);
                Assert.fail((String)"ImmutableHRegionInfo can't be modified !!!");
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        });
    }
}

