/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.nio.ByteBuffer;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.filter.LongComparator;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestLongComparator {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestLongComparator.class);
    private long[] values = new long[]{Long.MIN_VALUE, -10000000000L, -1000000L, 0L, 1000000L, 10000000000L, Long.MAX_VALUE};

    @Test
    public void testSimple() {
        for (int i = 1; i < this.values.length; ++i) {
            for (int j = 0; j < i; ++j) {
                LongComparator cp = new LongComparator(this.values[i]);
                Assert.assertEquals((long)1L, (long)cp.compareTo(Bytes.toBytes((long)this.values[j])));
                ByteBuffer data_bb = ByteBuffer.wrap(Bytes.toBytes((long)this.values[j]));
                Assert.assertEquals((long)1L, (long)cp.compareTo(data_bb, 0, data_bb.capacity()));
            }
        }
    }
}

