/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure2;

import java.io.IOException;
import java.util.Objects;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import org.apache.hadoop.hbase.procedure2.ProcedureSuspendedException;
import org.apache.hadoop.hbase.procedure2.ProcedureYieldException;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ProcedureProtos;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.NonceKey;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class FailedProcedure<TEnvironment>
extends Procedure<TEnvironment> {
    private String procName;

    public FailedProcedure() {
    }

    public FailedProcedure(long procId, String procName, User owner, NonceKey nonceKey, IOException exception) {
        this.procName = procName;
        this.setProcId(procId);
        this.setState(ProcedureProtos.ProcedureState.ROLLEDBACK);
        this.setOwner(owner);
        this.setNonceKey(nonceKey);
        long currentTime = EnvironmentEdgeManager.currentTime();
        this.setSubmittedTime(currentTime);
        this.setLastUpdate(currentTime);
        this.setFailure(Objects.toString(exception.getMessage(), ""), exception);
    }

    @Override
    public String getProcName() {
        return this.procName;
    }

    @Override
    protected Procedure<TEnvironment>[] execute(TEnvironment env) throws ProcedureYieldException, ProcedureSuspendedException, InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void rollback(TEnvironment env) throws IOException, InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected boolean abort(TEnvironment env) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
    }

    @Override
    protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
    }
}

