/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.library.vertexmanager;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.dag.library.vertexmanager.DestinationTaskInputsProperty;
import org.apache.tez.dag.library.vertexmanager.FairShuffleUserPayloads;

class FairEdgeConfiguration {
    private final int numBuckets;
    private final HashMap<Integer, DestinationTaskInputsProperty> destinationInputsProperties;

    public FairEdgeConfiguration(int numBuckets, HashMap<Integer, DestinationTaskInputsProperty> routingTable) {
        this.destinationInputsProperties = routingTable;
        this.numBuckets = numBuckets;
    }

    private FairShuffleUserPayloads.FairShuffleEdgeManagerConfigPayloadProto getConfigPayload() {
        FairShuffleUserPayloads.FairShuffleEdgeManagerConfigPayloadProto.Builder builder = FairShuffleUserPayloads.FairShuffleEdgeManagerConfigPayloadProto.newBuilder();
        builder.setNumBuckets(this.numBuckets);
        if (this.destinationInputsProperties != null) {
            for (Map.Entry<Integer, DestinationTaskInputsProperty> entry : this.destinationInputsProperties.entrySet()) {
                FairShuffleUserPayloads.FairShuffleEdgeManagerDestinationTaskPropProto.Builder taskBuilder = FairShuffleUserPayloads.FairShuffleEdgeManagerDestinationTaskPropProto.newBuilder();
                taskBuilder.setDestinationTaskIndex(entry.getKey()).setPartitions(this.newRange(entry.getValue().getFirstPartitionId(), entry.getValue().getNumOfPartitions())).setSourceTasks(this.newRange(entry.getValue().getFirstSourceTaskIndex(), entry.getValue().getNumOfSourceTasks()));
                builder.addDestinationTaskProps(taskBuilder.build());
            }
        }
        return builder.build();
    }

    private FairShuffleUserPayloads.RangeProto newRange(int firstIndex, int numOfIndexes) {
        return FairShuffleUserPayloads.RangeProto.newBuilder().setFirstIndex(firstIndex).setNumOfIndexes(numOfIndexes).build();
    }

    static FairEdgeConfiguration fromUserPayload(UserPayload payload) throws InvalidProtocolBufferException {
        HashMap<Integer, DestinationTaskInputsProperty> routingTable = new HashMap<Integer, DestinationTaskInputsProperty>();
        FairShuffleUserPayloads.FairShuffleEdgeManagerConfigPayloadProto proto = FairShuffleUserPayloads.FairShuffleEdgeManagerConfigPayloadProto.parseFrom(ByteString.copyFrom((ByteBuffer)payload.getPayload()));
        int numBuckets = proto.getNumBuckets();
        if (proto.getDestinationTaskPropsList() != null) {
            for (int i = 0; i < proto.getDestinationTaskPropsList().size(); ++i) {
                FairShuffleUserPayloads.FairShuffleEdgeManagerDestinationTaskPropProto propProto = proto.getDestinationTaskPropsList().get(i);
                routingTable.put(propProto.getDestinationTaskIndex(), new DestinationTaskInputsProperty(propProto.getPartitions().getFirstIndex(), propProto.getPartitions().getNumOfIndexes(), propProto.getSourceTasks().getFirstIndex(), propProto.getSourceTasks().getNumOfIndexes()));
            }
        }
        return new FairEdgeConfiguration(numBuckets, routingTable);
    }

    public HashMap<Integer, DestinationTaskInputsProperty> getRoutingTable() {
        return this.destinationInputsProperties;
    }

    int getNumBuckets() {
        return this.numBuckets;
    }

    UserPayload getBytePayload() {
        return UserPayload.create((ByteBuffer)ByteBuffer.wrap(this.getConfigPayload().toByteArray()));
    }
}

