/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.Serializable;

public class MemoryMonitorInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private boolean isLlap;
    private int executorsPerNode;
    private int maxExecutorsOverSubscribeMemory;
    private double memoryOverSubscriptionFactor;
    private long noConditionalTaskSize;
    private long adjustedNoConditionalTaskSize;
    private long memoryCheckInterval;
    private double hashTableInflationFactor;
    private long threshold;

    public MemoryMonitorInfo() {
    }

    public MemoryMonitorInfo(boolean isLlap, int executorsPerNode, int maxExecutorsOverSubscribeMemory, double memoryOverSubscriptionFactor, long noConditionalTaskSize, long adjustedNoConditionalTaskSize, long memoryCheckInterval, double hashTableInflationFactor) {
        this.isLlap = isLlap;
        this.executorsPerNode = executorsPerNode;
        this.maxExecutorsOverSubscribeMemory = maxExecutorsOverSubscribeMemory;
        this.memoryOverSubscriptionFactor = memoryOverSubscriptionFactor;
        this.noConditionalTaskSize = noConditionalTaskSize;
        this.adjustedNoConditionalTaskSize = adjustedNoConditionalTaskSize;
        this.memoryCheckInterval = memoryCheckInterval;
        this.hashTableInflationFactor = hashTableInflationFactor;
        this.threshold = (long)(hashTableInflationFactor * (double)adjustedNoConditionalTaskSize);
    }

    public MemoryMonitorInfo(MemoryMonitorInfo memoryMonitorInfo) {
        this.isLlap = memoryMonitorInfo.isLlap;
        this.executorsPerNode = memoryMonitorInfo.executorsPerNode;
        this.maxExecutorsOverSubscribeMemory = memoryMonitorInfo.maxExecutorsOverSubscribeMemory;
        this.memoryOverSubscriptionFactor = memoryMonitorInfo.memoryOverSubscriptionFactor;
        this.noConditionalTaskSize = memoryMonitorInfo.noConditionalTaskSize;
        this.adjustedNoConditionalTaskSize = memoryMonitorInfo.adjustedNoConditionalTaskSize;
        this.memoryCheckInterval = memoryMonitorInfo.memoryCheckInterval;
        this.hashTableInflationFactor = memoryMonitorInfo.hashTableInflationFactor;
        this.threshold = memoryMonitorInfo.threshold;
    }

    public int getExecutorsPerNode() {
        return this.executorsPerNode;
    }

    public void setExecutorsPerNode(int executorsPerNode) {
        this.executorsPerNode = executorsPerNode;
    }

    public int getMaxExecutorsOverSubscribeMemory() {
        return this.maxExecutorsOverSubscribeMemory;
    }

    public void setMaxExecutorsOverSubscribeMemory(int maxExecutorsOverSubscribeMemory) {
        this.maxExecutorsOverSubscribeMemory = maxExecutorsOverSubscribeMemory;
    }

    public double getMemoryOverSubscriptionFactor() {
        return this.memoryOverSubscriptionFactor;
    }

    public void setMemoryOverSubscriptionFactor(double memoryOverSubscriptionFactor) {
        this.memoryOverSubscriptionFactor = memoryOverSubscriptionFactor;
    }

    public long getNoConditionalTaskSize() {
        return this.noConditionalTaskSize;
    }

    public void setNoConditionalTaskSize(long noConditionalTaskSize) {
        this.noConditionalTaskSize = noConditionalTaskSize;
    }

    public long getAdjustedNoConditionalTaskSize() {
        return this.adjustedNoConditionalTaskSize;
    }

    public void setAdjustedNoConditionalTaskSize(long adjustedNoConditionalTaskSize) {
        this.adjustedNoConditionalTaskSize = adjustedNoConditionalTaskSize;
    }

    public long getMemoryCheckInterval() {
        return this.memoryCheckInterval;
    }

    public void setMemoryCheckInterval(long memoryCheckInterval) {
        this.memoryCheckInterval = memoryCheckInterval;
    }

    public double getHashTableInflationFactor() {
        return this.hashTableInflationFactor;
    }

    public void setHashTableInflationFactor(double hashTableInflationFactor) {
        this.hashTableInflationFactor = hashTableInflationFactor;
    }

    public long getThreshold() {
        return this.threshold;
    }

    public void setLlap(boolean llap) {
        this.isLlap = llap;
    }

    public boolean isLlap() {
        return this.isLlap;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append(" isLlap: ").append(this.isLlap);
        sb.append(" executorsPerNode: ").append(this.executorsPerNode);
        sb.append(" maxExecutorsOverSubscribeMemory: ").append(this.maxExecutorsOverSubscribeMemory);
        sb.append(" memoryOverSubscriptionFactor: ").append(this.memoryOverSubscriptionFactor);
        sb.append(" memoryCheckInterval: ").append(this.memoryCheckInterval);
        sb.append(" noConditionalTaskSize: ").append(this.noConditionalTaskSize);
        sb.append(" adjustedNoConditionalTaskSize: ").append(this.adjustedNoConditionalTaskSize);
        sb.append(" hashTableInflationFactor: ").append(this.hashTableInflationFactor);
        sb.append(" threshold: ").append(this.threshold);
        sb.append(" }");
        return sb.toString();
    }

    public boolean doMemoryMonitoring() {
        return this.isLlap && this.hashTableInflationFactor > 0.0 && this.noConditionalTaskSize > 0L && this.memoryCheckInterval > 0L;
    }

    public long getEffectiveThreshold(long maxMemoryPerExecutor) {
        return (long)Math.max((double)this.threshold, 0.6666666666666666 * (double)maxMemoryPerExecutor);
    }
}

