/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import java.io.IOException;
import org.apache.hadoop.hive.ql.exec.AbstractMapOperator;
import org.apache.hadoop.hive.ql.exec.mr.ExecMapperContext;
import org.apache.hadoop.hive.ql.exec.tez.RecordSource;
import org.apache.hadoop.hive.ql.exec.tez.tools.KeyValueInputMerger;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.util.StringUtils;
import org.apache.tez.mapreduce.lib.MRReader;
import org.apache.tez.runtime.library.api.KeyValueReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapRecordSource
implements RecordSource {
    public static final Logger LOG = LoggerFactory.getLogger(MapRecordSource.class);
    private ExecMapperContext execContext = null;
    private AbstractMapOperator mapOp = null;
    private KeyValueReader reader = null;
    private final boolean grouped = false;

    void init(JobConf jconf, AbstractMapOperator mapOp, KeyValueReader reader) throws IOException {
        this.execContext = mapOp.getExecContext();
        this.mapOp = mapOp;
        if (reader instanceof KeyValueInputMerger) {
            KeyValueInputMerger kvMerger = (KeyValueInputMerger)reader;
            kvMerger.setIOCxt(this.execContext.getIoCxt());
        }
        this.reader = reader;
    }

    @Override
    public final boolean isGrouped() {
        return false;
    }

    @Override
    public boolean pushRecord() throws HiveException {
        block4: {
            this.execContext.resetRow();
            try {
                Object value;
                if (!this.reader.next()) break block4;
                try {
                    value = this.reader.getCurrentValue();
                }
                catch (IOException e) {
                    this.closeReader();
                    throw new HiveException(e);
                }
                return this.processRow(value);
            }
            catch (IOException e) {
                this.closeReader();
                throw new HiveException(e);
            }
        }
        return false;
    }

    private boolean processRow(Object value) {
        try {
            if (this.mapOp.getDone()) {
                return false;
            }
            this.mapOp.process((Writable)value);
        }
        catch (Throwable e) {
            if (e instanceof OutOfMemoryError) {
                throw (OutOfMemoryError)e;
            }
            LOG.error(StringUtils.stringifyException((Throwable)e));
            this.closeReader();
            throw new RuntimeException(e);
        }
        return true;
    }

    private void closeReader() {
        if (!(this.reader instanceof MRReader)) {
            LOG.warn("Cannot close " + (this.reader == null ? null : this.reader.getClass()));
            return;
        }
        if (this.reader instanceof KeyValueInputMerger) {
            KeyValueInputMerger kvMerger = (KeyValueInputMerger)this.reader;
            kvMerger.clean();
        }
        LOG.info("Closing MRReader on error");
        MRReader mrReader = (MRReader)this.reader;
        try {
            mrReader.close();
        }
        catch (IOException ex) {
            LOG.error("Failed to close the reader; ignoring", (Throwable)ex);
        }
    }
}

