/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.util.Arrays;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.lazy.LazyByte;
import org.apache.hadoop.hive.serde2.lazy.LazyInteger;
import org.apache.hadoop.hive.serde2.lazy.LazyLong;
import org.apache.hadoop.hive.serde2.lazy.LazyShort;
import org.apache.hadoop.hive.serde2.lazy.LazyUtils;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;

public class CastStringToLong
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    int inputColumn;
    protected transient PrimitiveObjectInspector.PrimitiveCategory integerPrimitiveCategory;

    public CastStringToLong(int inputColumn, int outputColumnNum) {
        super(outputColumnNum);
        this.inputColumn = inputColumn;
    }

    public CastStringToLong() {
        this.inputColumn = -1;
    }

    @Override
    public void transientInit() throws HiveException {
        super.transientInit();
        this.integerPrimitiveCategory = ((PrimitiveTypeInfo)this.outputTypeInfo).getPrimitiveCategory();
    }

    /*
     * Unable to fully structure code
     */
    protected void func(LongColumnVector outputColVector, BytesColumnVector inputColVector, int batchIndex) {
        bytes = inputColVector.vector[batchIndex];
        start = inputColVector.start[batchIndex];
        length = inputColVector.length[batchIndex];
        try {
            switch (1.$SwitchMap$org$apache$hadoop$hive$serde2$objectinspector$PrimitiveObjectInspector$PrimitiveCategory[this.integerPrimitiveCategory.ordinal()]) {
                case 1: {
                    i = start;
                    if (length != 4) ** GOTO lbl15
                    if (bytes[i] != 84 && bytes[i] != 116 || bytes[i + 1] != 82 && bytes[i + 1] != 114 || bytes[i + 2] != 85 && bytes[i + 2] != 117 || bytes[i + 3] != 69 && bytes[i + 3] != 101) ** GOTO lbl12
                    booleanValue = true;
                    ** GOTO lbl36
lbl12:
                    // 1 sources

                    outputColVector.noNulls = false;
                    outputColVector.isNull[batchIndex] = true;
                    return;
lbl15:
                    // 1 sources

                    if (length != 5) ** GOTO lbl22
                    if (bytes[i] != 70 && bytes[i] != 102 || bytes[i + 1] != 65 && bytes[i + 1] != 97 || bytes[i + 2] != 76 && bytes[i + 2] != 108 || bytes[i + 3] != 83 && bytes[i + 3] != 115 || bytes[i + 4] != 69 && bytes[i + 4] != 101) ** GOTO lbl19
                    booleanValue = false;
                    ** GOTO lbl36
lbl19:
                    // 1 sources

                    outputColVector.noNulls = false;
                    outputColVector.isNull[batchIndex] = true;
                    return;
lbl22:
                    // 1 sources

                    if (length != 1) ** GOTO lbl33
                    b = bytes[start];
                    if (b == 49 || b == 116 || b == 84) {
                        booleanValue = true;
                    } else if (b == 48 || b == 102 || b == 70) {
                        booleanValue = false;
                    } else {
                        outputColVector.noNulls = false;
                        outputColVector.isNull[batchIndex] = true;
                        return;
lbl33:
                        // 1 sources

                        outputColVector.noNulls = false;
                        outputColVector.isNull[batchIndex] = true;
                        return;
                    }
lbl36:
                    // 4 sources

                    outputColVector.vector[batchIndex] = booleanValue != false ? 1 : 0;
                    break;
                }
                case 2: {
                    if (!LazyUtils.isNumberMaybe((byte[])bytes, (int)start, (int)length)) {
                        outputColVector.noNulls = false;
                        outputColVector.isNull[batchIndex] = true;
                        return;
                    }
                    outputColVector.vector[batchIndex] = LazyByte.parseByte((byte[])bytes, (int)start, (int)length, (int)10);
                    break;
                }
                case 3: {
                    if (!LazyUtils.isNumberMaybe((byte[])bytes, (int)start, (int)length)) {
                        outputColVector.noNulls = false;
                        outputColVector.isNull[batchIndex] = true;
                        return;
                    }
                    outputColVector.vector[batchIndex] = LazyShort.parseShort((byte[])bytes, (int)start, (int)length, (int)10);
                    break;
                }
                case 4: {
                    if (!LazyUtils.isNumberMaybe((byte[])bytes, (int)start, (int)length)) {
                        outputColVector.noNulls = false;
                        outputColVector.isNull[batchIndex] = true;
                        return;
                    }
                    outputColVector.vector[batchIndex] = LazyInteger.parseInt((byte[])bytes, (int)start, (int)length, (int)10);
                    break;
                }
                case 5: {
                    if (!LazyUtils.isNumberMaybe((byte[])bytes, (int)start, (int)length)) {
                        outputColVector.noNulls = false;
                        outputColVector.isNull[batchIndex] = true;
                        return;
                    }
                    outputColVector.vector[batchIndex] = LazyLong.parseLong((byte[])bytes, (int)start, (int)length, (int)10);
                    break;
                }
                default: {
                    throw new Error("Unexpected primitive category " + this.integerPrimitiveCategory);
                }
            }
        }
        catch (Exception e) {
            outputColVector.noNulls = false;
            outputColVector.isNull[batchIndex] = true;
        }
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        BytesColumnVector inputColVector = (BytesColumnVector)batch.cols[this.inputColumn];
        int[] sel = batch.selected;
        int n = batch.size;
        LongColumnVector outputColVector = (LongColumnVector)batch.cols[this.outputColumnNum];
        boolean[] inputIsNull = inputColVector.isNull;
        boolean[] outputIsNull = outputColVector.isNull;
        if (n == 0) {
            return;
        }
        outputColVector.isRepeating = false;
        if (inputColVector.isRepeating) {
            if (inputColVector.noNulls || !inputIsNull[0]) {
                outputIsNull[0] = false;
                this.func(outputColVector, inputColVector, 0);
            } else {
                outputIsNull[0] = true;
                outputColVector.noNulls = false;
            }
            outputColVector.isRepeating = true;
            return;
        }
        if (inputColVector.noNulls) {
            if (batch.selectedInUse) {
                if (!outputColVector.noNulls) {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        outputIsNull[i] = false;
                        this.func(outputColVector, inputColVector, i);
                    }
                } else {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        this.func(outputColVector, inputColVector, i);
                    }
                }
            } else {
                if (!outputColVector.noNulls) {
                    Arrays.fill(outputIsNull, false);
                    outputColVector.noNulls = true;
                }
                for (int i = 0; i != n; ++i) {
                    this.func(outputColVector, inputColVector, i);
                }
            }
        } else if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                if (!inputColVector.isNull[i]) {
                    outputColVector.isNull[i] = false;
                    this.func(outputColVector, inputColVector, i);
                    continue;
                }
                outputColVector.isNull[i] = true;
                outputColVector.noNulls = false;
            }
        } else {
            for (int i = 0; i != n; ++i) {
                if (!inputColVector.isNull[i]) {
                    outputColVector.isNull[i] = false;
                    this.func(outputColVector, inputColVector, i);
                    continue;
                }
                outputColVector.isNull[i] = true;
                outputColVector.noNulls = false;
            }
        }
    }

    @Override
    public String vectorExpressionParameters() {
        return this.getColumnParamString(0, this.inputColumn);
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        VectorExpressionDescriptor.Builder b = new VectorExpressionDescriptor.Builder();
        b.setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(1).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.STRING_FAMILY).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN);
        return b.build();
    }
}

