/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.OrcSerde;
import org.apache.hadoop.hive.ql.io.orc.Writer;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StandardStructObjectInspector;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;

public class OrcNewOutputFormat
extends FileOutputFormat<NullWritable, OrcSerde.OrcSerdeRow> {
    public RecordWriter getRecordWriter(TaskAttemptContext context) throws IOException, InterruptedException {
        Path file = this.getDefaultWorkFile(context, "");
        return new OrcRecordWriter(file, OrcFile.writerOptions(ShimLoader.getHadoopShims().getConfiguration((JobContext)context)));
    }

    private static class OrcRecordWriter
    extends RecordWriter<NullWritable, OrcSerde.OrcSerdeRow> {
        private Writer writer = null;
        private final Path path;
        private final OrcFile.WriterOptions options;

        OrcRecordWriter(Path path, OrcFile.WriterOptions options) {
            this.path = path;
            this.options = options;
        }

        public void write(NullWritable key, OrcSerde.OrcSerdeRow row) throws IOException, InterruptedException {
            if (this.writer == null) {
                this.options.inspector(row.getInspector());
                this.writer = OrcFile.createWriter(this.path, this.options);
            }
            this.writer.addRow(row.getRow());
        }

        public void close(TaskAttemptContext context) throws IOException, InterruptedException {
            if (this.writer == null) {
                StandardStructObjectInspector inspector = ObjectInspectorFactory.getStandardStructObjectInspector(new ArrayList(), new ArrayList());
                this.options.inspector((ObjectInspector)inspector);
                this.writer = OrcFile.createWriter(this.path, this.options);
            }
            this.writer.close();
        }
    }
}

