/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.ql.io.AcidInputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcSplit;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.orc.OrcProto;
import org.apache.orc.impl.OrcTail;

public class OrcNewSplit
extends FileSplit {
    private OrcTail orcTail;
    private boolean hasFooter;
    private boolean isOriginal;
    private boolean hasBase;
    private final List<AcidInputFormat.DeltaMetaData> deltas = new ArrayList<AcidInputFormat.DeltaMetaData>();

    protected OrcNewSplit() {
        super(null, 0L, 0L, null);
    }

    public OrcNewSplit(OrcSplit inner) throws IOException {
        super(inner.getPath(), inner.getStart(), inner.getLength(), inner.getLocations());
        this.orcTail = inner.getOrcTail();
        this.hasFooter = inner.hasFooter();
        this.isOriginal = inner.isOriginal();
        this.hasBase = inner.hasBase();
        this.deltas.addAll(inner.getDeltas());
    }

    public void write(DataOutput out) throws IOException {
        super.write(out);
        int flags = (this.hasBase ? 4 : 0) | (this.isOriginal ? 2 : 0) | (this.hasFooter ? 1 : 0);
        out.writeByte(flags);
        out.writeInt(this.deltas.size());
        for (AcidInputFormat.DeltaMetaData delta : this.deltas) {
            delta.write(out);
        }
        if (this.hasFooter) {
            OrcProto.FileTail fileTail = this.orcTail.getMinimalFileTail();
            byte[] tailBuffer = fileTail.toByteArray();
            int tailLen = tailBuffer.length;
            WritableUtils.writeVInt((DataOutput)out, (int)tailLen);
            out.write(tailBuffer);
        }
    }

    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        byte flags = in.readByte();
        this.hasFooter = (1 & flags) != 0;
        this.isOriginal = (2 & flags) != 0;
        this.hasBase = (4 & flags) != 0;
        this.deltas.clear();
        int numDeltas = in.readInt();
        for (int i = 0; i < numDeltas; ++i) {
            AcidInputFormat.DeltaMetaData dmd = new AcidInputFormat.DeltaMetaData();
            dmd.readFields(in);
            this.deltas.add(dmd);
        }
        if (this.hasFooter) {
            int tailLen = WritableUtils.readVInt((DataInput)in);
            byte[] tailBuffer = new byte[tailLen];
            in.readFully(tailBuffer);
            OrcProto.FileTail fileTail = OrcProto.FileTail.parseFrom((byte[])tailBuffer);
            this.orcTail = new OrcTail(fileTail, null);
        }
    }

    public OrcTail getOrcTail() {
        return this.orcTail;
    }

    public boolean hasFooter() {
        return this.hasFooter;
    }

    public boolean isOriginal() {
        return this.isOriginal;
    }

    public boolean hasBase() {
        return this.hasBase;
    }

    public List<AcidInputFormat.DeltaMetaData> getDeltas() {
        return this.deltas;
    }
}

