/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.spark;

import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedOutputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.exec.MapJoinOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.optimizer.spark.SparkPartitionPruningSinkDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.api.OperatorType;
import org.apache.hadoop.hive.serde2.Serializer;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkPartitionPruningSinkOperator
extends Operator<SparkPartitionPruningSinkDesc> {
    protected transient Serializer serializer;
    protected transient DataOutputBuffer buffer;
    protected static final Logger LOG = LoggerFactory.getLogger(SparkPartitionPruningSinkOperator.class);
    private static final AtomicLong SEQUENCE_NUM = new AtomicLong(0L);
    private transient String uniqueId = null;

    @VisibleForTesting
    public SparkPartitionPruningSinkOperator() {
    }

    public SparkPartitionPruningSinkOperator(CompilationOpContext ctx) {
        super(ctx);
    }

    @Override
    public void initializeOp(Configuration hconf) throws HiveException {
        super.initializeOp(hconf);
        this.serializer = (Serializer)ReflectionUtils.newInstance(((SparkPartitionPruningSinkDesc)this.conf).getTable().getDeserializerClass(), null);
        this.buffer = new DataOutputBuffer();
    }

    @Override
    public void process(Object row, int tag) throws HiveException {
        ObjectInspector rowInspector = this.inputObjInspectors[0];
        try {
            Writable writableRow = this.serializer.serialize(row, rowInspector);
            writableRow.write((DataOutput)this.buffer);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    @Override
    public void closeOp(boolean abort) throws HiveException {
        if (!abort) {
            try {
                this.flushToFile();
            }
            catch (Exception e) {
                throw new HiveException(e);
            }
        }
    }

    public boolean isWithMapjoin() {
        Operator<?> branchingOp = this.getBranchingOp();
        for (Operator<OperatorDesc> childOp : branchingOp.getChildOperators()) {
            if (!(childOp instanceof ReduceSinkOperator) || !(childOp.getChildOperators().get(0) instanceof MapJoinOperator)) continue;
            return true;
        }
        return false;
    }

    public Operator<?> getBranchingOp() {
        Operator branchingOp = this;
        while (branchingOp != null && branchingOp.getNumChild() <= 1) {
            branchingOp = branchingOp.getParentOperators().get(0);
        }
        return branchingOp;
    }

    private void flushToFile() throws IOException {
        Path path = ((SparkPartitionPruningSinkDesc)this.conf).getPath();
        FileSystem fs = path.getFileSystem(this.getConfiguration());
        fs.mkdirs(path);
        while (fs.exists(path = new Path(path, String.valueOf(Utilities.randGen.nextInt())))) {
        }
        short numOfRepl = fs.getDefaultReplication(path);
        ObjectOutputStream out = null;
        FSDataOutputStream fsout = null;
        try {
            fsout = fs.create(path, numOfRepl);
            out = new ObjectOutputStream(new BufferedOutputStream((OutputStream)fsout));
            out.writeInt(((SparkPartitionPruningSinkDesc)this.conf).getTargetInfos().size());
            for (SparkPartitionPruningSinkDesc.DPPTargetInfo info : ((SparkPartitionPruningSinkDesc)this.conf).getTargetInfos()) {
                out.writeUTF(info.columnName);
            }
            this.buffer.writeTo((OutputStream)out);
        }
        catch (Exception e) {
            try {
                fs.delete(path, false);
            }
            catch (Exception ex) {
                LOG.warn("Exception happened while trying to clean partial file.");
            }
            throw e;
        }
        finally {
            if (out != null) {
                LOG.info("Flushed to file: " + path);
                out.close();
            } else if (fsout != null) {
                fsout.close();
            }
        }
    }

    @Override
    public OperatorType getType() {
        return OperatorType.SPARKPRUNINGSINK;
    }

    @Override
    public String getName() {
        return SparkPartitionPruningSinkOperator.getOperatorName();
    }

    public static String getOperatorName() {
        return "SPARKPRUNINGSINK";
    }

    public synchronized String getUniqueId() {
        if (this.uniqueId == null) {
            this.uniqueId = this.getOperatorId() + "_" + SEQUENCE_NUM.getAndIncrement();
        }
        return this.uniqueId;
    }

    public synchronized void setUniqueId(String uniqueId) {
        this.uniqueId = uniqueId;
    }

    public void addAsSourceEvent(MapWork mapWork, ExprNodeDesc partKey, String columnName, String columnType) {
        String sourceId = this.getUniqueId();
        SparkPartitionPruningSinkDesc conf = (SparkPartitionPruningSinkDesc)this.getConf();
        List tableDescs = mapWork.getEventSourceTableDescMap().computeIfAbsent(sourceId, v -> new ArrayList());
        tableDescs.add(conf.getTable());
        List partKeys = mapWork.getEventSourcePartKeyExprMap().computeIfAbsent(sourceId, v -> new ArrayList());
        partKeys.add(partKey);
        List columnNames = mapWork.getEventSourceColumnNameMap().computeIfAbsent(sourceId, v -> new ArrayList());
        columnNames.add(columnName);
        List columnTypes = mapWork.getEventSourceColumnTypeMap().computeIfAbsent(sourceId, v -> new ArrayList());
        columnTypes.add(columnType);
    }

    public void removeFromSourceEvent(MapWork mapWork, ExprNodeDesc partKey, String columnName, String columnType) {
        List<String> columnTypes;
        List<String> columnNames;
        List<ExprNodeDesc> partKeys;
        String sourceId = this.getUniqueId();
        SparkPartitionPruningSinkDesc conf = (SparkPartitionPruningSinkDesc)this.getConf();
        List<TableDesc> tableDescs = mapWork.getEventSourceTableDescMap().get(sourceId);
        if (tableDescs != null) {
            tableDescs.remove(conf.getTable());
            if (tableDescs.isEmpty()) {
                mapWork.getEventSourceTableDescMap().remove(sourceId);
            }
        }
        if ((partKeys = mapWork.getEventSourcePartKeyExprMap().get(sourceId)) != null) {
            partKeys.remove(partKey);
            if (partKeys.isEmpty()) {
                mapWork.getEventSourcePartKeyExprMap().remove(sourceId);
            }
        }
        if ((columnNames = mapWork.getEventSourceColumnNameMap().get(sourceId)) != null) {
            columnNames.remove(columnName);
            if (columnNames.isEmpty()) {
                mapWork.getEventSourceColumnNameMap().remove(sourceId);
            }
        }
        if ((columnTypes = mapWork.getEventSourceColumnTypeMap().get(sourceId)) != null) {
            columnTypes.remove(columnType);
            if (columnTypes.isEmpty()) {
                mapWork.getEventSourceColumnTypeMap().remove(sourceId);
            }
        }
    }
}

