/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import org.apache.hadoop.hive.ql.plan.Explain;

@Explain(displayName="Edge Property")
public class SparkEdgeProperty {
    public static final long SHUFFLE_NONE = 0L;
    public static final long SHUFFLE_GROUP = 1L;
    public static final long SHUFFLE_SORT = 2L;
    public static final long MR_SHUFFLE_SORT = 4L;
    private long edgeType;
    private int numPartitions;

    public SparkEdgeProperty(long edgeType, int numPartitions) {
        this.edgeType = edgeType;
        this.numPartitions = numPartitions;
    }

    public SparkEdgeProperty(long edgeType) {
        this.edgeType = edgeType;
    }

    public boolean isShuffleNone() {
        return this.edgeType == 0L;
    }

    public void setShuffleNone() {
        this.edgeType = 0L;
    }

    public boolean isShuffleGroup() {
        return (this.edgeType & 1L) != 0L;
    }

    public void setShuffleGroup() {
        this.edgeType |= 1L;
    }

    public void setMRShuffle() {
        this.edgeType |= 4L;
    }

    public boolean isMRShuffle() {
        return (this.edgeType & 4L) != 0L;
    }

    public void setShuffleSort() {
        this.edgeType |= 2L;
    }

    public boolean isShuffleSort() {
        return (this.edgeType & 2L) != 0L;
    }

    public long getEdgeType() {
        return this.edgeType;
    }

    @Explain(displayName="Shuffle Type")
    public String getShuffleType() {
        if (this.isShuffleNone()) {
            return "NONE";
        }
        StringBuilder sb = new StringBuilder();
        if (this.isShuffleGroup()) {
            sb.append("GROUP");
        }
        if (this.isMRShuffle()) {
            if (sb.length() != 0) {
                sb.append(" ");
            }
            sb.append("PARTITION-LEVEL SORT");
        }
        if (this.isShuffleSort()) {
            if (sb.length() != 0) {
                sb.append(" ");
            }
            sb.append("SORT");
        }
        return sb.toString();
    }

    public int getNumPartitions() {
        return this.numPartitions;
    }

    public void setNumPartitions(int numPartitions) {
        this.numPartitions = numPartitions;
    }
}

