/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedExpressions;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FuncLog2DoubleToDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FuncLog2LongToDouble;
import org.apache.hadoop.hive.ql.udf.UDFMath;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;

@Description(name="log2", value="_FUNC_(x) - Returns the logarithm of x with base 2", extended="Example:\n  > SELECT _FUNC_(2) FROM src LIMIT 1;\n  1")
@VectorizedExpressions(value={FuncLog2LongToDouble.class, FuncLog2DoubleToDouble.class})
public class UDFLog2
extends UDFMath {
    private static final double LOG_2 = Math.log(2.0);
    private final DoubleWritable result = new DoubleWritable();

    @Override
    protected DoubleWritable doEvaluate(DoubleWritable a) {
        if (a.get() <= 0.0) {
            return null;
        }
        this.result.set(Math.log(a.get()) / LOG_2);
        return this.result;
    }
}

