/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedExpressions;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FuncSqrtDoubleToDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FuncSqrtLongToDouble;
import org.apache.hadoop.hive.ql.udf.UDFMath;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;

@Description(name="sqrt", value="_FUNC_(x) - returns the square root of x", extended="Example:\n   > SELECT _FUNC_(4) FROM src LIMIT 1;\n  2")
@VectorizedExpressions(value={FuncSqrtLongToDouble.class, FuncSqrtDoubleToDouble.class})
public class UDFSqrt
extends UDFMath {
    private final DoubleWritable result = new DoubleWritable();

    @Override
    protected DoubleWritable doEvaluate(DoubleWritable a) {
        if (a.get() < 0.0) {
            return null;
        }
        this.result.set(Math.sqrt(a.get()));
        return this.result;
    }
}

