/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.ql.udf.generic.MaskTransformer;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;

class MaskFirstNTransformer
extends MaskTransformer {
    int charCount = 4;

    @Override
    public void init(ObjectInspector[] arguments, int argsStartIdx) {
        super.init(arguments, argsStartIdx + 1);
        this.charCount = this.getIntArg(arguments, argsStartIdx, 4);
        if (this.charCount < 0) {
            this.charCount = 0;
        }
    }

    @Override
    String transform(String value) {
        int i;
        StringBuilder ret = new StringBuilder(value.length());
        int endIdx = value.length() < this.charCount ? value.length() : this.charCount;
        for (i = 0; i < endIdx; ++i) {
            ret.appendCodePoint(this.transformChar(value.charAt(i)));
        }
        for (i = endIdx; i < value.length(); ++i) {
            ret.appendCodePoint(value.charAt(i));
        }
        return ret.toString();
    }

    @Override
    Byte transform(Byte value) {
        byte val = value;
        if (value < 0) {
            val = (byte)(val * -1);
        }
        int digitCount = 0;
        for (byte v = val; v != 0; v = (byte)(v / 10)) {
            ++digitCount;
        }
        int retainCount = digitCount < this.charCount ? 0 : digitCount - this.charCount;
        byte ret = 0;
        int pos = 1;
        int i = 0;
        while (val != 0) {
            ret = i >= retainCount ? (byte)(ret + this.maskedNumber * pos) : (byte)(ret + val % 10 * pos);
            val = (byte)(val / 10);
            pos *= 10;
            ++i;
        }
        if (value < 0) {
            ret = (byte)(ret * -1);
        }
        return ret;
    }

    @Override
    Short transform(Short value) {
        short val = value;
        if (value < 0) {
            val = (short)(val * -1);
        }
        int digitCount = 0;
        for (short v = val; v != 0; v = (short)(v / 10)) {
            ++digitCount;
        }
        int retainCount = digitCount < this.charCount ? 0 : digitCount - this.charCount;
        short ret = 0;
        int pos = 1;
        int i = 0;
        while (val != 0) {
            ret = i >= retainCount ? (short)(ret + this.maskedNumber * pos) : (short)(ret + val % 10 * pos);
            val = (short)(val / 10);
            pos *= 10;
            ++i;
        }
        if (value < 0) {
            ret = (short)(ret * -1);
        }
        return ret;
    }

    @Override
    Integer transform(Integer value) {
        int val = value;
        if (value < 0) {
            val *= -1;
        }
        int digitCount = 0;
        for (int v = val; v != 0; v /= 10) {
            ++digitCount;
        }
        int retainCount = digitCount < this.charCount ? 0 : digitCount - this.charCount;
        int ret = 0;
        int pos = 1;
        int i = 0;
        while (val != 0) {
            ret = i >= retainCount ? (ret += this.maskedNumber * pos) : (ret += val % 10 * pos);
            val /= 10;
            pos *= 10;
            ++i;
        }
        if (value < 0) {
            ret *= -1;
        }
        return ret;
    }

    @Override
    Long transform(Long value) {
        long val = value;
        if (value < 0L) {
            val *= -1L;
        }
        int digitCount = 0;
        for (long v = val; v != 0L; v /= 10L) {
            ++digitCount;
        }
        int retainCount = digitCount < this.charCount ? 0 : digitCount - this.charCount;
        long ret = 0L;
        long pos = 1L;
        int i = 0;
        while (val != 0L) {
            ret = i >= retainCount ? (ret += (long)this.maskedNumber * pos) : (ret += val % 10L * pos);
            val /= 10L;
            pos *= 10L;
            ++i;
        }
        if (value < 0L) {
            ret *= -1L;
        }
        return ret;
    }
}

