/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.log;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.nio.channels.ClosedChannelException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.accumulo.core.client.Durability;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.impl.KeyExtent;
import org.apache.accumulo.core.security.crypto.CryptoModule;
import org.apache.accumulo.core.security.crypto.CryptoModuleFactory;
import org.apache.accumulo.core.security.crypto.CryptoModuleParameters;
import org.apache.accumulo.core.security.crypto.DefaultCryptoModule;
import org.apache.accumulo.core.security.crypto.NoFlushOutputStream;
import org.apache.accumulo.core.util.Daemon;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.fate.util.LoggingRunnable;
import org.apache.accumulo.server.ServerConstants;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.tserver.TabletMutations;
import org.apache.accumulo.tserver.logger.LogEvents;
import org.apache.accumulo.tserver.logger.LogFileKey;
import org.apache.accumulo.tserver.logger.LogFileValue;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSOutputStream;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.gaul.modernizer_maven_annotations.SuppressModernizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DfsLogger
implements Comparable<DfsLogger> {
    public static final String LOG_FILE_HEADER_V2 = "--- Log File Header (v2) ---";
    public static final String LOG_FILE_HEADER_V3 = "--- Log File Header (v3) ---";
    private static final Logger log = LoggerFactory.getLogger(DfsLogger.class);
    private static final DatanodeInfo[] EMPTY_PIPELINE = new DatanodeInfo[0];
    private final LinkedBlockingQueue<LogWork> workQueue = new LinkedBlockingQueue();
    private final Object closeLock = new Object();
    private static final LogWork CLOSED_MARKER = new LogWork(null, Durability.FLUSH);
    private static final LogFileValue EMPTY = new LogFileValue();
    private boolean closed = false;
    static final LoggerOperation NO_WAIT_LOGGER_OP = new NoWaitLoggerOperation();
    private final ServerResources conf;
    private FSDataOutputStream logFile;
    private DataOutputStream encryptingLogFile = null;
    private Method sync;
    private Method flush;
    private String logPath;
    private Daemon syncThread;
    private String metaReference;
    private AtomicLong syncCounter;
    private AtomicLong flushCounter;
    private final long slowFlushMillis;
    private long writes = 0L;

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof DfsLogger) {
            return this.getFileName().equals(((DfsLogger)obj).getFileName());
        }
        return false;
    }

    public int hashCode() {
        return this.getFileName().hashCode();
    }

    private DfsLogger(ServerResources conf) {
        this.conf = conf;
        this.slowFlushMillis = conf.getConfiguration().getTimeInMillis(Property.TSERV_SLOW_FLUSH_MILLIS);
    }

    public DfsLogger(ServerResources conf, AtomicLong syncCounter, AtomicLong flushCounter) throws IOException {
        this(conf);
        this.syncCounter = syncCounter;
        this.flushCounter = flushCounter;
    }

    public DfsLogger(ServerResources conf, String filename, String meta) throws IOException {
        this(conf);
        this.logPath = filename;
        this.metaReference = meta;
    }

    public static DFSLoggerInputStreams readHeaderAndReturnStream(FSDataInputStream input, AccumuloConfiguration conf) throws IOException {
        Object decryptingInput = null;
        byte[] magic = LOG_FILE_HEADER_V3.getBytes(StandardCharsets.UTF_8);
        byte[] magicBuffer = new byte[magic.length];
        try {
            input.readFully(magicBuffer);
            if (Arrays.equals(magicBuffer, magic)) {
                String cryptoModuleClassname = input.readUTF();
                CryptoModule cryptoModule = CryptoModuleFactory.getCryptoModule((String)cryptoModuleClassname);
                CryptoModuleParameters params = CryptoModuleFactory.createParamsObjectFromAccumuloConfiguration((AccumuloConfiguration)conf);
                params.setEncryptedInputStream((InputStream)input);
                params = cryptoModule.getDecryptingInputStream(params);
                decryptingInput = params.getPlaintextInputStream() instanceof DataInputStream ? (DataInputStream)params.getPlaintextInputStream() : new DataInputStream(params.getPlaintextInputStream());
            } else {
                input.seek(0L);
                byte[] magicV2 = LOG_FILE_HEADER_V2.getBytes(StandardCharsets.UTF_8);
                byte[] magicBufferV2 = new byte[magicV2.length];
                input.readFully(magicBufferV2);
                if (Arrays.equals(magicBufferV2, magicV2)) {
                    HashMap<String, String> opts = new HashMap<String, String>();
                    int count = input.readInt();
                    for (int i = 0; i < count; ++i) {
                        String key = input.readUTF();
                        String value = input.readUTF();
                        opts.put(key, value);
                    }
                    if (opts.size() == 0) {
                        decryptingInput = input;
                    } else {
                        CryptoModule cryptoModule = CryptoModuleFactory.getCryptoModule((String)DefaultCryptoModule.class.getName());
                        CryptoModuleParameters params = CryptoModuleFactory.createParamsObjectFromAccumuloConfiguration((AccumuloConfiguration)conf);
                        input.seek((long)magicV2.length);
                        params.setEncryptedInputStream((InputStream)input);
                        params = cryptoModule.getDecryptingInputStream(params);
                        decryptingInput = params.getPlaintextInputStream() instanceof DataInputStream ? (DataInputStream)params.getPlaintextInputStream() : new DataInputStream(params.getPlaintextInputStream());
                    }
                } else {
                    input.seek(0L);
                    decryptingInput = input;
                }
            }
        }
        catch (EOFException e) {
            log.warn("Got EOFException trying to read WAL header information, assuming the rest of the file has no data.");
            throw new LogHeaderIncompleteException(e);
        }
        return new DFSLoggerInputStreams(input, (DataInputStream)decryptingInput);
    }

    @SuppressModernizer
    public synchronized void open(String address) throws IOException {
        String filename = UUID.randomUUID().toString();
        log.debug("Address is " + address);
        String logger = Joiner.on((String)"+").join((Object[])address.split(":"));
        log.debug("DfsLogger.open() begin");
        VolumeManager fs = this.conf.getFileSystem();
        this.logPath = fs.choose(Optional.absent(), ServerConstants.getBaseUris()) + "/" + "wal" + "/" + logger + "/" + filename;
        this.metaReference = this.toString();
        LoggerOperation op = null;
        try {
            long blockSize;
            short replication = (short)this.conf.getConfiguration().getCount(Property.TSERV_WAL_REPLICATION);
            if (replication == 0) {
                replication = fs.getDefaultReplication(new Path(this.logPath));
            }
            if ((blockSize = this.conf.getConfiguration().getMemoryInBytes(Property.TSERV_WAL_BLOCKSIZE)) == 0L) {
                blockSize = (long)((double)this.conf.getConfiguration().getMemoryInBytes(Property.TSERV_WALOG_MAX_SIZE) * 1.1);
            }
            this.logFile = this.conf.getConfiguration().getBoolean(Property.TSERV_WAL_SYNC) ? fs.createSyncable(new Path(this.logPath), 0, replication, blockSize) : fs.create(new Path(this.logPath), true, 0, replication, blockSize);
            this.sync = this.logFile.getClass().getMethod("hsync", new Class[0]);
            this.flush = this.logFile.getClass().getMethod("hflush", new Class[0]);
            CryptoModule cryptoModule = CryptoModuleFactory.getCryptoModule((String)this.conf.getConfiguration().get(Property.CRYPTO_MODULE_CLASS));
            this.logFile.write(LOG_FILE_HEADER_V3.getBytes(StandardCharsets.UTF_8));
            CryptoModuleParameters params = CryptoModuleFactory.createParamsObjectFromAccumuloConfiguration((AccumuloConfiguration)this.conf.getConfiguration());
            NoFlushOutputStream nfos = new NoFlushOutputStream((OutputStream)this.logFile);
            params.setPlaintextOutputStream((OutputStream)nfos);
            this.logFile.writeUTF(this.conf.getConfiguration().get(Property.CRYPTO_MODULE_CLASS));
            params = cryptoModule.getEncryptingOutputStream(params);
            OutputStream encipheringOutputStream = params.getEncryptedOutputStream();
            if (encipheringOutputStream == nfos) {
                log.debug("No enciphering, using raw output stream");
                this.encryptingLogFile = nfos;
            } else {
                log.debug("Enciphering found, wrapping in DataOutputStream");
                this.encryptingLogFile = new DataOutputStream(encipheringOutputStream);
            }
            LogFileKey key = new LogFileKey();
            key.event = LogEvents.OPEN;
            key.tserverSession = filename;
            key.filename = filename;
            op = this.logFileData(Collections.singletonList(new Pair((Object)key, (Object)EMPTY)), Durability.SYNC);
        }
        catch (Exception ex) {
            if (this.logFile != null) {
                this.logFile.close();
            }
            this.logFile = null;
            this.encryptingLogFile = null;
            throw new IOException(ex);
        }
        this.syncThread = new Daemon((Runnable)new LoggingRunnable(log, (Runnable)new LogSyncingTask()));
        this.syncThread.setName("Accumulo WALog thread " + this.toString());
        this.syncThread.start();
        op.await();
        log.debug("Got new write-ahead log: " + this);
    }

    public String toString() {
        String fileName = this.getFileName();
        if (fileName.contains(":")) {
            return this.getLogger() + "/" + this.getFileName();
        }
        return fileName;
    }

    public String getMeta() {
        if (null == this.metaReference) {
            throw new IllegalStateException("logger doesn't have meta reference. " + this);
        }
        return this.metaReference;
    }

    public String getFileName() {
        return this.logPath;
    }

    public Path getPath() {
        return new Path(this.logPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.closeLock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.workQueue.add(CLOSED_MARKER);
        }
        if (this.syncThread != null) {
            try {
                this.syncThread.join();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.workQueue.size() != 0) {
            log.error("WAL work queue not empty after sync thread exited");
            throw new IllegalStateException("WAL work queue not empty after sync thread exited");
        }
        if (this.encryptingLogFile != null) {
            try {
                this.logFile.close();
            }
            catch (IOException ex) {
                log.error("Failed to close log file", (Throwable)ex);
                throw new LogClosedException();
            }
        }
    }

    public synchronized long getWrites() {
        Preconditions.checkState((this.writes >= 0L ? 1 : 0) != 0);
        return this.writes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void defineTablet(long seq, int tid, KeyExtent tablet) throws IOException {
        LogFileKey key = new LogFileKey();
        key.event = LogEvents.DEFINE_TABLET;
        key.seq = seq;
        key.tabletId = tid;
        key.tablet = tablet;
        try {
            this.write(key, EMPTY);
        }
        catch (IllegalArgumentException e) {
            log.error("Signature of sync method changed. Accumulo is likely incompatible with this version of Hadoop.");
            throw new RuntimeException(e);
        }
        Object object = this.closeLock;
        synchronized (object) {
            if (this.closed) {
                throw new LogClosedException();
            }
        }
    }

    private synchronized void write(LogFileKey key, LogFileValue value) throws IOException {
        key.write(this.encryptingLogFile);
        value.write(this.encryptingLogFile);
        this.encryptingLogFile.flush();
        ++this.writes;
    }

    public LoggerOperation log(long seq, int tid, Mutation mutation, Durability durability) throws IOException {
        return this.logManyTablets(Collections.singletonList(new TabletMutations(tid, seq, Collections.singletonList(mutation), durability)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LoggerOperation logFileData(List<Pair<LogFileKey, LogFileValue>> keys, Durability durability) throws IOException {
        LogWork work = new LogWork(new CountDownLatch(1), durability);
        Object object = this;
        synchronized (object) {
            try {
                for (Pair<LogFileKey, LogFileValue> pair : keys) {
                    this.write((LogFileKey)pair.getFirst(), (LogFileValue)pair.getSecond());
                }
            }
            catch (ClosedChannelException ex) {
                throw new LogClosedException();
            }
            catch (Exception e) {
                log.error("Failed to write log entries", (Throwable)e);
                work.exception = e;
            }
        }
        object = this.closeLock;
        synchronized (object) {
            if (this.closed) {
                throw new LogClosedException();
            }
            if (durability == Durability.LOG) {
                return NO_WAIT_LOGGER_OP;
            }
            this.workQueue.add(work);
        }
        return new LoggerOperation(work);
    }

    public LoggerOperation logManyTablets(List<TabletMutations> mutations) throws IOException {
        Durability durability = Durability.NONE;
        ArrayList<Pair<LogFileKey, LogFileValue>> data = new ArrayList<Pair<LogFileKey, LogFileValue>>();
        for (TabletMutations tabletMutations : mutations) {
            LogFileKey key = new LogFileKey();
            key.event = LogEvents.MANY_MUTATIONS;
            key.seq = tabletMutations.getSeq();
            key.tabletId = tabletMutations.getTid();
            LogFileValue value = new LogFileValue();
            value.mutations = tabletMutations.getMutations();
            data.add((Pair<LogFileKey, LogFileValue>)new Pair((Object)key, (Object)value));
            if (tabletMutations.getDurability().ordinal() <= durability.ordinal()) continue;
            durability = tabletMutations.getDurability();
        }
        return this.logFileData(data, DfsLogger.chooseDurabilityForGroupCommit(mutations));
    }

    static Durability chooseDurabilityForGroupCommit(List<TabletMutations> mutations) {
        Durability result = Durability.NONE;
        for (TabletMutations tabletMutations : mutations) {
            if (tabletMutations.getDurability().ordinal() <= result.ordinal()) continue;
            result = tabletMutations.getDurability();
        }
        return result;
    }

    public LoggerOperation minorCompactionFinished(long seq, int tid, String fqfn, Durability durability) throws IOException {
        LogFileKey key = new LogFileKey();
        key.event = LogEvents.COMPACTION_FINISH;
        key.seq = seq;
        key.tabletId = tid;
        return this.logFileData(Collections.singletonList(new Pair((Object)key, (Object)EMPTY)), durability);
    }

    public LoggerOperation minorCompactionStarted(long seq, int tid, String fqfn, Durability durability) throws IOException {
        LogFileKey key = new LogFileKey();
        key.event = LogEvents.COMPACTION_START;
        key.seq = seq;
        key.tabletId = tid;
        key.filename = fqfn;
        return this.logFileData(Collections.singletonList(new Pair((Object)key, (Object)EMPTY)), durability);
    }

    public String getLogger() {
        String[] parts = this.logPath.split("/");
        return Joiner.on((String)":").join((Object[])parts[parts.length - 2].split("[+]"));
    }

    @Override
    public int compareTo(DfsLogger o) {
        return this.getFileName().compareTo(o.getFileName());
    }

    DatanodeInfo[] getPipeLine() {
        OutputStream os;
        if (null != this.logFile && (os = this.logFile.getWrappedStream()) instanceof DFSOutputStream) {
            return ((DFSOutputStream)os).getPipeline();
        }
        return EMPTY_PIPELINE;
    }

    private static class NoWaitLoggerOperation
    extends LoggerOperation {
        public NoWaitLoggerOperation() {
            super(null);
        }

        @Override
        public void await() throws IOException {
        }
    }

    static class LoggerOperation {
        private final LogWork work;

        public LoggerOperation(LogWork work) {
            this.work = work;
        }

        public void await() throws IOException {
            try {
                this.work.latch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            if (this.work.exception != null) {
                if (this.work.exception instanceof IOException) {
                    throw (IOException)this.work.exception;
                }
                if (this.work.exception instanceof RuntimeException) {
                    throw (RuntimeException)this.work.exception;
                }
                throw new RuntimeException(this.work.exception);
            }
        }
    }

    private static class LogWork {
        final CountDownLatch latch;
        final Durability durability;
        volatile Exception exception;

        public LogWork(CountDownLatch latch, Durability durability) {
            this.latch = latch;
            this.durability = durability;
        }
    }

    private class LogSyncingTask
    implements Runnable {
        private int expectedReplication = 0;

        private LogSyncingTask() {
        }

        @Override
        public void run() {
            ArrayList<LogWork> work = new ArrayList<LogWork>();
            boolean sawClosedMarker = false;
            while (!sawClosedMarker) {
                work.clear();
                try {
                    work.add((LogWork)DfsLogger.this.workQueue.take());
                }
                catch (InterruptedException ex) {
                    continue;
                }
                DfsLogger.this.workQueue.drainTo(work);
                Method durabilityMethod = null;
                block14: for (LogWork logWork : work) {
                    switch (logWork.durability) {
                        case DEFAULT: 
                        case NONE: 
                        case LOG: {
                            throw new IllegalArgumentException("unexpected durability " + logWork.durability);
                        }
                        case SYNC: {
                            durabilityMethod = DfsLogger.this.sync;
                            break block14;
                        }
                        case FLUSH: {
                            if (durabilityMethod == null) {
                                durabilityMethod = DfsLogger.this.flush;
                            }
                        }
                        default: {
                            continue block14;
                        }
                    }
                }
                long start = System.currentTimeMillis();
                try {
                    if (durabilityMethod != null) {
                        durabilityMethod.invoke((Object)DfsLogger.this.logFile, new Object[0]);
                        if (durabilityMethod == DfsLogger.this.sync) {
                            DfsLogger.this.syncCounter.incrementAndGet();
                        } else {
                            DfsLogger.this.flushCounter.incrementAndGet();
                        }
                    }
                }
                catch (Exception ex) {
                    this.fail(work, ex, "synching");
                }
                long duration = System.currentTimeMillis() - start;
                if (duration > DfsLogger.this.slowFlushMillis) {
                    String msg = new StringBuilder(128).append("Slow sync cost: ").append(duration).append(" ms, current pipeline: ").append(Arrays.toString(DfsLogger.this.getPipeLine())).toString();
                    log.info(msg);
                    if (this.expectedReplication > 0) {
                        int current = this.expectedReplication;
                        try {
                            current = ((DFSOutputStream)DfsLogger.this.logFile.getWrappedStream()).getCurrentBlockReplication();
                        }
                        catch (IOException e) {
                            this.fail(work, e, "getting replication level");
                        }
                        if (current < this.expectedReplication) {
                            this.fail(work, new IOException("replication of " + current + " is less than " + this.expectedReplication), "replication check");
                        }
                    }
                }
                if (this.expectedReplication == 0 && DfsLogger.this.logFile.getWrappedStream() instanceof DFSOutputStream) {
                    try {
                        this.expectedReplication = ((DFSOutputStream)DfsLogger.this.logFile.getWrappedStream()).getCurrentBlockReplication();
                    }
                    catch (IOException e) {
                        this.fail(work, e, "getting replication level");
                    }
                }
                for (LogWork logWork : work) {
                    if (logWork == CLOSED_MARKER) {
                        sawClosedMarker = true;
                        continue;
                    }
                    logWork.latch.countDown();
                }
            }
        }

        private void fail(ArrayList<LogWork> work, Exception ex, String why) {
            log.warn("Exception " + why + " " + ex);
            for (LogWork logWork : work) {
                logWork.exception = ex;
            }
        }
    }

    public static interface ServerResources {
        public AccumuloConfiguration getConfiguration();

        public VolumeManager getFileSystem();
    }

    public static class DFSLoggerInputStreams {
        private FSDataInputStream originalInput;
        private DataInputStream decryptingInputStream;

        public DFSLoggerInputStreams(FSDataInputStream originalInput, DataInputStream decryptingInputStream) {
            this.originalInput = originalInput;
            this.decryptingInputStream = decryptingInputStream;
        }

        public FSDataInputStream getOriginalInput() {
            return this.originalInput;
        }

        public void setOriginalInput(FSDataInputStream originalInput) {
            this.originalInput = originalInput;
        }

        public DataInputStream getDecryptingInputStream() {
            return this.decryptingInputStream;
        }

        public void setDecryptingInputStream(DataInputStream decryptingInputStream) {
            this.decryptingInputStream = decryptingInputStream;
        }
    }

    public static class LogHeaderIncompleteException
    extends IOException {
        private static final long serialVersionUID = 1L;

        public LogHeaderIncompleteException(Throwable cause) {
            super(cause);
        }
    }

    public static class LogClosedException
    extends IOException {
        private static final long serialVersionUID = 1L;

        public LogClosedException() {
            super("LogClosed");
        }
    }
}

