/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.metrics;

import javax.management.ObjectName;
import org.apache.accumulo.server.metrics.AbstractMetricsImpl;
import org.apache.accumulo.tserver.metrics.TabletServerMinCMetricsMBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TabletServerMinCMetrics
extends AbstractMetricsImpl
implements TabletServerMinCMetricsMBean {
    static final Logger log = LoggerFactory.getLogger(TabletServerMinCMetrics.class);
    private static final String METRICS_PREFIX = "tserver.minc";
    private ObjectName OBJECT_NAME = null;

    TabletServerMinCMetrics() {
        this.reset();
        try {
            this.OBJECT_NAME = new ObjectName("accumulo.server.metrics:service=TServerInfo,name=TabletServerMinCMetricsMBean,instance=" + Thread.currentThread().getName());
        }
        catch (Exception e) {
            log.error("Exception setting MBean object name", (Throwable)e);
        }
    }

    protected ObjectName getObjectName() {
        return this.OBJECT_NAME;
    }

    protected String getMetricsPrefix() {
        return METRICS_PREFIX;
    }

    @Override
    public long getMinorCompactionMinTime() {
        return this.getMetricMin("minc");
    }

    @Override
    public long getMinorCompactionAvgTime() {
        return this.getMetricAvg("minc");
    }

    @Override
    public long getMinorCompactionCount() {
        return this.getMetricCount("minc");
    }

    @Override
    public long getMinorCompactionMaxTime() {
        return this.getMetricMax("minc");
    }

    @Override
    public long getMinorCompactionQueueAvgTime() {
        return this.getMetricAvg("queue");
    }

    @Override
    public long getMinorCompactionQueueCount() {
        return this.getMetricCount("queue");
    }

    @Override
    public long getMinorCompactionQueueMaxTime() {
        return this.getMetricMax("queue");
    }

    @Override
    public long getMinorCompactionQueueMinTime() {
        return this.getMetricMin("minc");
    }

    @Override
    public void reset() {
        this.createMetric("minc");
        this.createMetric("queue");
    }
}

