/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.scan;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.accumulo.tserver.TabletServer;
import org.apache.accumulo.tserver.scan.ScanRunState;

public abstract class ScanTask<T>
implements RunnableFuture<T> {
    protected final TabletServer server;
    protected AtomicBoolean interruptFlag;
    protected ArrayBlockingQueue<Object> resultQueue;
    protected AtomicInteger state;
    protected AtomicReference<ScanRunState> runState;
    private static final int INITIAL = 1;
    private static final int ADDED = 2;
    private static final int CANCELED = 3;

    ScanTask(TabletServer server) {
        this.server = server;
        this.interruptFlag = new AtomicBoolean(false);
        this.runState = new AtomicReference<ScanRunState>(ScanRunState.QUEUED);
        this.state = new AtomicInteger(1);
        this.resultQueue = new ArrayBlockingQueue(1);
    }

    protected void addResult(Object o) {
        if (this.state.compareAndSet(1, 2)) {
            this.resultQueue.add(o);
        } else if (this.state.get() == 2) {
            throw new IllegalStateException("Tried to add more than one result");
        }
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (!mayInterruptIfRunning) {
            throw new IllegalArgumentException("Cancel will always attempt to interupt running next batch task");
        }
        if (this.state.get() == 3) {
            return true;
        }
        if (this.state.compareAndSet(1, 3)) {
            this.interruptFlag.set(true);
            this.resultQueue = null;
            return true;
        }
        return false;
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        throw new UnsupportedOperationException();
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        ArrayBlockingQueue<Object> localRQ = this.resultQueue;
        if (this.isCancelled()) {
            throw new CancellationException();
        }
        if (localRQ == null) {
            String stateStr;
            int st = this.state.get();
            switch (st) {
                case 2: {
                    stateStr = "ADDED";
                    break;
                }
                case 3: {
                    stateStr = "CANCELED";
                    break;
                }
                case 1: {
                    stateStr = "INITIAL";
                    break;
                }
                default: {
                    stateStr = "UNKNOWN";
                }
            }
            throw new IllegalStateException("Tried to get result twice [state=" + stateStr + "(" + st + ")]");
        }
        Object r = localRQ.poll(timeout, unit);
        if (this.isCancelled()) {
            if (r != null) {
                throw new IllegalStateException("Nothing should have been added when in canceled state");
            }
            throw new CancellationException();
        }
        if (r == null) {
            throw new TimeoutException();
        }
        this.resultQueue = null;
        if (r instanceof Throwable) {
            throw new ExecutionException((Throwable)r);
        }
        Object rAsT = r;
        return (T)rAsT;
    }

    @Override
    public boolean isCancelled() {
        return this.state.get() == 3;
    }

    @Override
    public boolean isDone() {
        return this.runState.get().equals((Object)ScanRunState.FINISHED);
    }

    public ScanRunState getScanRunState() {
        return this.runState.get();
    }
}

