/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.piggybank.evaluation.decode;

import java.io.IOException;
import org.apache.pig.EvalFunc;
import org.apache.pig.PigWarning;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.schema.Schema;

public class BinCond
extends EvalFunc<String> {
    int numParams = -1;

    public Schema outputSchema(Schema input) {
        try {
            return new Schema(new Schema.FieldSchema(this.getSchemaName(((Object)((Object)this)).getClass().getName().toLowerCase(), input), 55));
        }
        catch (Exception e) {
            return null;
        }
    }

    public String exec(Tuple tuple) throws IOException {
        if (this.numParams == -1) {
            this.numParams = tuple.size();
            if (this.numParams <= 2) {
                String msg = "BinCond : UDF requires atleast one condition, mapping string & a default string.";
                throw new IOException(msg);
            }
            if (tuple.size() % 2 != 1) {
                String msg = "BinCond : Some parameters are unmatched.";
                throw new IOException(msg);
            }
        }
        if (tuple.get(0) == null) {
            return null;
        }
        try {
            for (int count = 0; count < this.numParams; count += 2) {
                int returnIndex = -1;
                if (count == this.numParams - 1) {
                    returnIndex = count;
                } else if (((Boolean)tuple.get(count)).booleanValue()) {
                    returnIndex = count + 1;
                }
                if (returnIndex < 0) continue;
                return (String)tuple.get(returnIndex);
            }
        }
        catch (ClassCastException e) {
            this.warn("BinCond : Data type error", (Enum)PigWarning.UDF_WARNING_1);
            return null;
        }
        catch (NullPointerException e) {
            String msg = "BinCond : Encounter null in the input";
            throw new IOException(msg);
        }
        String msg = "BinCond : Internal Failure";
        throw new IOException(msg);
    }
}

