/*
 * Decompiled with CFR 0.152.
 */
package com.headius.invokebinder.transform;

import com.headius.invokebinder.transform.Transform;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;

public class Collect
extends Transform {
    private final MethodType source;
    private int index;
    private final Class arrayType;

    public Collect(MethodType source2, int index2, Class arrayType) {
        this.source = source2;
        this.index = index2;
        this.arrayType = arrayType;
    }

    @Override
    public MethodHandle up(MethodHandle target) {
        return target.asCollector(this.arrayType, this.source.parameterCount() - this.index);
    }

    @Override
    public MethodType down(MethodType type2) {
        this.assertTypesAreCompatible();
        return type2.dropParameterTypes(this.index, this.source.parameterCount()).appendParameterTypes(this.arrayType);
    }

    private void assertTypesAreCompatible() {
        Class<?> componentType = this.arrayType.getComponentType();
        for (int i2 = this.index; i2 < this.source.parameterCount(); ++i2) {
            TypeDescriptor.OfField in = this.source.parameterType(i2);
            assert (((Class)in).isAssignableFrom(componentType)) : "incoming type " + ((Class)in).getName() + " not compatible with " + componentType.getName() + "[]";
        }
    }

    @Override
    public String toString() {
        return "collect at " + this.index + " into " + this.arrayType.getName();
    }
}

