/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport.binding;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.javasupport.JavaClass;
import org.jruby.javasupport.binding.ConstantField;
import org.jruby.javasupport.binding.Initializer;
import org.jruby.javasupport.binding.MethodInstaller;
import org.jruby.javasupport.binding.NamedInstaller;

public class InterfaceInitializer
extends Initializer {
    public InterfaceInitializer(Ruby runtime, Class<?> javaClass) {
        super(runtime, javaClass);
    }

    @Override
    public RubyModule initialize(RubyModule proxy2) {
        Initializer.State state2 = new Initializer.State(this.runtime, null);
        super.initializeBase(proxy2);
        Field[] fields2 = JavaClass.getDeclaredFields(this.javaClass);
        int i2 = fields2.length;
        while (--i2 >= 0) {
            int mod;
            Field field2 = fields2[i2];
            if (this.javaClass != field2.getDeclaringClass()) continue;
            if (ConstantField.isConstant(field2)) {
                state2.constantFields.add(new ConstantField(field2));
            }
            if (!Modifier.isStatic(mod = field2.getModifiers())) continue;
            InterfaceInitializer.addField(state2.staticInstallers, state2.staticNames, field2, Modifier.isFinal(mod), true);
        }
        InterfaceInitializer.setupInterfaceMethods(this.javaClass, state2);
        InterfaceInitializer.handleScalaSingletons(this.javaClass, state2);
        for (Map.Entry<String, NamedInstaller> entry : state2.staticInstallers.entrySet()) {
            NamedInstaller installer = entry.getValue();
            if (installer.type != 2 || !installer.hasLocalMethod()) continue;
            InterfaceInitializer.assignAliases((MethodInstaller)installer, state2.staticNames);
        }
        this.runtime.getJavaSupport().getStaticAssignedNames().get(this.javaClass).putAll(state2.staticNames);
        this.runtime.getJavaSupport().getInstanceAssignedNames().get(this.javaClass).clear();
        proxy2.setJavaProxy(true);
        proxy2.getSingletonClass().setJavaProxy(true);
        InterfaceInitializer.installClassFields(proxy2, state2);
        InterfaceInitializer.installClassStaticMethods(proxy2, state2);
        InterfaceInitializer.installClassClasses(this.javaClass, proxy2);
        proxy2.getName();
        return proxy2;
    }

    private static void setupInterfaceMethods(Class<?> javaClass, Initializer.State state2) {
        List<Method> methods2 = InterfaceInitializer.getMethods(javaClass);
        int i2 = methods2.size();
        while (--i2 >= 0) {
            Method method2 = methods2.get(i2);
            String name2 = method2.getName();
            if (!Modifier.isStatic(method2.getModifiers())) continue;
            InterfaceInitializer.prepareStaticMethod(javaClass, state2, method2, name2);
        }
        InterfaceInitializer.assignStaticAliases(state2);
    }
}

