/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.IOException;
import java.io.InputStream;
import jnr.constants.platform.Errno;
import org.jruby.util.FileResource;
import org.jruby.util.ResourceException;

abstract class AbstractFileResource
implements FileResource {
    AbstractFileResource() {
    }

    @Override
    public boolean canExecute() {
        return false;
    }

    @Override
    public int errno() {
        return Errno.ENOENT.intValue();
    }

    @Override
    public InputStream inputStream() throws ResourceException {
        if (!this.exists()) {
            throw new ResourceException.NotFound(this.absolutePath());
        }
        if (this.isDirectory()) {
            throw new ResourceException.FileIsDirectory(this.absolutePath());
        }
        try {
            return this.openInputStream();
        }
        catch (IOException e) {
            throw new ResourceException.IOError(e);
        }
    }

    abstract InputStream openInputStream() throws IOException;
}

