/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.nodelabels;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.yarn.api.records.NodeAttribute;
import org.apache.hadoop.yarn.api.records.NodeLabel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NodeLabelsUtils {
    private static final Logger LOG = LoggerFactory.getLogger(NodeLabelsUtils.class);

    private NodeLabelsUtils() {
    }

    public static Set<String> convertToStringSet(Set<NodeLabel> nodeLabels) {
        if (null == nodeLabels) {
            return null;
        }
        HashSet<String> labels = new HashSet<String>();
        for (NodeLabel label : nodeLabels) {
            labels.add(label.getName());
        }
        return labels;
    }

    public static void verifyCentralizedNodeLabelConfEnabled(String operation, boolean isCentralizedNodeLabelConfiguration) throws IOException {
        if (!isCentralizedNodeLabelConfiguration) {
            String msg = String.format("Error when invoke method=%s because centralized node label configuration is not enabled.", operation);
            LOG.error(msg);
            throw new IOException(msg);
        }
    }

    public static Set<NodeAttribute> getNodeAttributesByName(Set<String> attributeNames, Set<NodeAttribute> clusterNodeAttributes) {
        return clusterNodeAttributes.stream().filter(attribute -> attributeNames.contains(attribute.getAttributeKey().getAttributeName())).collect(Collectors.toSet());
    }
}

