/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.placement;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.yarn.server.resourcemanager.placement.PlacementRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public final class PlacementFactory {
    private static final Logger LOG = LoggerFactory.getLogger(PlacementFactory.class);

    private PlacementFactory() {
    }

    public static PlacementRule getPlacementRule(String ruleStr, Configuration conf) throws ClassNotFoundException {
        Class<PlacementRule> ruleClass = Class.forName(ruleStr).asSubclass(PlacementRule.class);
        LOG.info("Using PlacementRule implementation - " + ruleClass);
        return (PlacementRule)ReflectionUtils.newInstance(ruleClass, (Configuration)conf);
    }

    public static PlacementRule getPlacementRule(Class<? extends PlacementRule> ruleClass, Object initArg) {
        LOG.info("Creating PlacementRule implementation: " + ruleClass);
        PlacementRule rule = (PlacementRule)ReflectionUtils.newInstance(ruleClass, null);
        rule.setConfig(initArg);
        return rule;
    }
}

