/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class ReservationQueueConfiguration {
    private long reservationWindow = 86400000L;
    private long enforcementWindow = 3600000L;
    private String reservationAdmissionPolicy = "org.apache.hadoop.yarn.server.resourcemanager.reservation.CapacityOverTimePolicy";
    private String reservationAgent = "org.apache.hadoop.yarn.server.resourcemanager.reservation.planning.AlignedPlannerWithGreedy";
    private String planner = "org.apache.hadoop.yarn.server.resourcemanager.reservation.planning.SimpleCapacityReplanner";
    private boolean showReservationAsQueues = false;
    private boolean moveOnExpiry = true;
    private float avgOverTimeMultiplier = 1.0f;
    private float maxOverTimeMultiplier = 1.0f;

    public long getReservationWindowMsec() {
        return this.reservationWindow;
    }

    public long getEnforcementWindowMsec() {
        return this.enforcementWindow;
    }

    public boolean shouldShowReservationAsQueues() {
        return this.showReservationAsQueues;
    }

    public boolean shouldMoveOnExpiry() {
        return this.moveOnExpiry;
    }

    public String getReservationAdmissionPolicy() {
        return this.reservationAdmissionPolicy;
    }

    public String getReservationAgent() {
        return this.reservationAgent;
    }

    public String getPlanner() {
        return this.planner;
    }

    public float getAvgOverTimeMultiplier() {
        return this.avgOverTimeMultiplier;
    }

    public float getMaxOverTimeMultiplier() {
        return this.maxOverTimeMultiplier;
    }

    public void setPlanner(String planner) {
        this.planner = planner;
    }

    public void setReservationAdmissionPolicy(String reservationAdmissionPolicy) {
        this.reservationAdmissionPolicy = reservationAdmissionPolicy;
    }

    public void setReservationAgent(String reservationAgent) {
        this.reservationAgent = reservationAgent;
    }

    @VisibleForTesting
    public void setReservationWindow(long reservationWindow) {
        this.reservationWindow = reservationWindow;
    }

    @VisibleForTesting
    public void setAverageCapacity(int averageCapacity) {
        this.avgOverTimeMultiplier = averageCapacity;
    }
}

