/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp.dao;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities.ActivityNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities.AppAllocation;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.RMWSConsts;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppRequestAllocationInfo;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class AppAllocationInfo {
    private String nodeId;
    private Long timestamp;
    private String dateTime;
    private String queueName;
    private Integer appPriority;
    private String allocationState;
    private String diagnostic;
    private List<AppRequestAllocationInfo> children;

    AppAllocationInfo() {
    }

    AppAllocationInfo(AppAllocation allocation, RMWSConsts.ActivitiesGroupBy groupBy) {
        this.children = new ArrayList<AppRequestAllocationInfo>();
        this.nodeId = allocation.getNodeId();
        this.queueName = allocation.getQueueName();
        this.appPriority = allocation.getPriority() == null ? null : Integer.valueOf(allocation.getPriority().getPriority());
        this.timestamp = allocation.getTime();
        this.dateTime = new Date(allocation.getTime()).toString();
        this.allocationState = allocation.getActivityState().name();
        this.diagnostic = allocation.getDiagnostic();
        Map requestToActivityNodes = allocation.getAllocationAttempts().stream().collect(Collectors.groupingBy(e -> e.getRequestPriority() + "_" + e.getAllocationRequestId(), Collectors.toList()));
        for (List<ActivityNode> list : requestToActivityNodes.values()) {
            AppRequestAllocationInfo requestAllocationInfo = new AppRequestAllocationInfo(list, groupBy);
            this.children.add(requestAllocationInfo);
        }
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public String getQueueName() {
        return this.queueName;
    }

    public Integer getAppPriority() {
        return this.appPriority;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public String getDateTime() {
        return this.dateTime;
    }

    public String getAllocationState() {
        return this.allocationState;
    }

    public List<AppRequestAllocationInfo> getChildren() {
        return this.children;
    }

    public String getDiagnostic() {
        return this.diagnostic;
    }
}

