/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.mapreduce.hadoop;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.tez.mapreduce.combine.MRCombiner;
import org.apache.tez.mapreduce.hadoop.MultiStageMRConfigUtil;
import org.apache.tez.mapreduce.partition.MRPartitioner;

public final class MultiStageMRConfToTezTranslator {
    private MultiStageMRConfToTezTranslator() {
    }

    @InterfaceAudience.Private
    public static Configuration[] getStageConfs(Configuration conf) {
        Configuration nonItermediateConf;
        int numIntermediateStages = MultiStageMRConfigUtil.getNumIntermediateStages(conf);
        boolean hasFinalReduceStage = conf.getInt("mapreduce.job.reduces", 0) > 0;
        int numStages = numIntermediateStages + (hasFinalReduceStage ? 2 : 1);
        conf.setBoolean("mapreduce.tez.splits.via.events", false);
        conf.set("tez.runtime.partitioner.class", MRPartitioner.class.getName());
        boolean useNewApi = conf.getBoolean("mapred.mapper.new-api", false);
        if (useNewApi) {
            if (conf.get("mapreduce.job.combine.class") != null) {
                conf.set("tez.runtime.combiner.class", MRCombiner.class.getName());
            }
        } else if (conf.get("mapred.combiner.class") != null) {
            conf.set("tez.runtime.combiner.class", MRCombiner.class.getName());
        }
        Configuration[] confs = new Configuration[numStages];
        confs[0] = nonItermediateConf = MultiStageMRConfigUtil.extractStageConf(conf, "");
        if (numStages == 1) {
            confs[0].setBoolean("tez.mapreduce.is_map_processor", true);
        } else {
            confs[numStages - 1] = new Configuration(nonItermediateConf);
            confs[numStages - 1].setBoolean("tez.mapreduce.is_map_processor", false);
        }
        if (numStages > 2) {
            for (int i = 1; i < numStages - 1; ++i) {
                confs[i] = MultiStageMRConfigUtil.extractStageConf(conf, MultiStageMRConfigUtil.getPropertyNameForIntermediateStage(i, ""));
                confs[i].setBoolean("tez.mapreduce.is_map_processor", false);
            }
        }
        return confs;
    }
}

