/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.gc.metrics;

import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.gc.thrift.GcCycleStats;
import org.apache.accumulo.gc.SimpleGarbageCollector;
import org.apache.accumulo.gc.metrics.GcCycleMetrics;
import org.apache.accumulo.server.metrics.Metrics;
import org.apache.accumulo.server.metrics.MetricsSystemHelper;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.impl.MsInfo;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableGaugeLong;

public class GcMetrics
implements Metrics,
MetricsSource {
    public static final String GC_METRIC_PREFIX = "AccGc";
    public static final String CONTEXT = "accgc";
    private static final String jmxName = "GarbageCollector";
    private final String DESCRIPTION = "Accumulo garbage collection metrics";
    private final String RECORD = "AccGcCycleMetrics";
    private final SimpleGarbageCollector gc;
    private final MetricsSystem metricsSystem;
    private final MetricsRegistry registry;
    private final MutableGaugeLong gcStarted;
    private final MutableGaugeLong gcFinished;
    private final MutableGaugeLong gcCandidates;
    private final MutableGaugeLong gcInUse;
    private final MutableGaugeLong gcDeleted;
    private final MutableGaugeLong gcErrors;
    private final MutableGaugeLong walStarted;
    private final MutableGaugeLong walFinished;
    private final MutableGaugeLong walCandidates;
    private final MutableGaugeLong walInUse;
    private final MutableGaugeLong walDeleted;
    private final MutableGaugeLong walErrors;
    private final MutableGaugeLong postOpDuration;
    private final MutableGaugeLong runCycleCount;
    private final boolean metrics2enabled;

    public GcMetrics(SimpleGarbageCollector gc, boolean metrics2enabled) {
        this.gc = gc;
        this.metrics2enabled = metrics2enabled;
        this.metricsSystem = MetricsSystemHelper.getInstance();
        this.registry = new MetricsRegistry(Interns.info((String)("GarbageCollector,sub=" + ((Object)((Object)gc)).getClass().getSimpleName()), (String)"Accumulo garbage collection metrics"));
        this.registry.tag((MetricsInfo)MsInfo.ProcessName, MetricsSystemHelper.getProcessName());
        this.gcStarted = this.registry.newGauge("AccGcStarted", "Timestamp GC file collection cycle started", 0L);
        this.gcFinished = this.registry.newGauge("AccGcFinished", "Timestamp GC file collect cycle finished", 0L);
        this.gcCandidates = this.registry.newGauge("AccGcCandidates", "Number of files that are candidates for deletion", 0L);
        this.gcInUse = this.registry.newGauge("AccGcInUse", "Number of candidate files still in use", 0L);
        this.gcDeleted = this.registry.newGauge("AccGcDeleted", "Number of candidate files deleted", 0L);
        this.gcErrors = this.registry.newGauge("AccGcErrors", "Number of candidate deletion errors", 0L);
        this.walStarted = this.registry.newGauge("AccGcWalStarted", "Timestamp GC WAL collection started", 0L);
        this.walFinished = this.registry.newGauge("AccGcWalFinished", "Timestamp GC WAL collection finished", 0L);
        this.walCandidates = this.registry.newGauge("AccGcWalCandidates", "Number of files that are candidates for deletion", 0L);
        this.walInUse = this.registry.newGauge("AccGcWalInUse", "Number of wal file candidates that are still in use", 0L);
        this.walDeleted = this.registry.newGauge("AccGcWalDeleted", "Number of candidate wal files deleted", 0L);
        this.walErrors = this.registry.newGauge("AccGcWalErrors", "Number candidate wal file deletion errors", 0L);
        this.postOpDuration = this.registry.newGauge("AccGcPostOpDuration", "GC metadata table post operation duration in milliseconds", 0L);
        this.runCycleCount = this.registry.newGauge("AccGcRunCycleCount", "gauge incremented each gc cycle run, rest on process start", 0L);
    }

    public void register() throws Exception {
        if (this.metrics2enabled) {
            this.metricsSystem.register("GarbageCollector,sub=" + ((Object)((Object)this.gc)).getClass().getSimpleName(), "Accumulo garbage collection metrics", (Object)this);
        }
    }

    public void add(String name, long time) {
        throw new UnsupportedOperationException("add() is not implemented");
    }

    public boolean isEnabled() {
        return true;
    }

    public void getMetrics(MetricsCollector collector, boolean all) {
        GcCycleMetrics values = this.gc.getGcCycleMetrics();
        GcCycleStats lastFileCollect = values.getLastCollect();
        this.gcStarted.set(lastFileCollect.getStarted());
        this.gcFinished.set(lastFileCollect.getFinished());
        this.gcCandidates.set(lastFileCollect.getCandidates());
        this.gcInUse.set(lastFileCollect.getInUse());
        this.gcDeleted.set(lastFileCollect.getDeleted());
        this.gcErrors.set(lastFileCollect.getErrors());
        GcCycleStats lastWalCollect = values.getLastWalCollect();
        this.walStarted.set(lastWalCollect.getStarted());
        this.walFinished.set(lastWalCollect.getFinished());
        this.walCandidates.set(lastWalCollect.getCandidates());
        this.walInUse.set(lastWalCollect.getInUse());
        this.walDeleted.set(lastWalCollect.getDeleted());
        this.walErrors.set(lastWalCollect.getErrors());
        this.postOpDuration.set(TimeUnit.NANOSECONDS.toMillis(values.getPostOpDurationNanos()));
        this.runCycleCount.set(values.getRunCycleCount());
        MetricsRecordBuilder builder = collector.addRecord("AccGcCycleMetrics").setContext(CONTEXT);
        this.registry.snapshot(builder, all);
    }
}

