/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.conf;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.junit.Assert;
import org.junit.Test;

public class TestDeprecatedKeys {
    @Test
    public void testDeprecatedKeys() throws Exception {
        Configuration conf = new Configuration();
        conf.set("topology.script.file.name", "xyz");
        conf.set("topology.script.file.name", "xyz");
        String scriptFile = conf.get("net.topology.script.file.name");
        Assert.assertEquals((Object)"xyz", (Object)scriptFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadWriteWithDeprecatedKeys() throws Exception {
        String fileContents;
        Configuration conf = new Configuration();
        conf.setBoolean("old.config.yet.to.be.deprecated", true);
        Configuration.addDeprecation((String)"old.config.yet.to.be.deprecated", (String[])new String[]{"new.conf.to.replace.deprecated.conf"});
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            conf.writeXml((OutputStream)out);
            fileContents = out.toString();
        }
        Assert.assertTrue((boolean)fileContents.contains("old.config.yet.to.be.deprecated"));
        Assert.assertTrue((boolean)fileContents.contains("new.conf.to.replace.deprecated.conf"));
    }

    @Test
    public void testIteratorWithDeprecatedKeysMappedToMultipleNewKeys() {
        Configuration conf = new Configuration();
        Configuration.addDeprecation((String)"dK", (String[])new String[]{"nK1", "nK2"});
        conf.set("k", "v");
        conf.set("dK", "V");
        Assert.assertEquals((Object)"V", (Object)conf.get("dK"));
        Assert.assertEquals((Object)"V", (Object)conf.get("nK1"));
        Assert.assertEquals((Object)"V", (Object)conf.get("nK2"));
        conf.set("nK1", "VV");
        Assert.assertEquals((Object)"VV", (Object)conf.get("dK"));
        Assert.assertEquals((Object)"VV", (Object)conf.get("nK1"));
        Assert.assertEquals((Object)"VV", (Object)conf.get("nK2"));
        conf.set("nK2", "VVV");
        Assert.assertEquals((Object)"VVV", (Object)conf.get("dK"));
        Assert.assertEquals((Object)"VVV", (Object)conf.get("nK2"));
        Assert.assertEquals((Object)"VVV", (Object)conf.get("nK1"));
        boolean kFound = false;
        boolean dKFound = false;
        boolean nK1Found = false;
        boolean nK2Found = false;
        for (Map.Entry entry : conf) {
            if (((String)entry.getKey()).equals("k")) {
                Assert.assertEquals((Object)"v", entry.getValue());
                kFound = true;
            }
            if (((String)entry.getKey()).equals("dK")) {
                Assert.assertEquals((Object)"VVV", entry.getValue());
                dKFound = true;
            }
            if (((String)entry.getKey()).equals("nK1")) {
                Assert.assertEquals((Object)"VVV", entry.getValue());
                nK1Found = true;
            }
            if (!((String)entry.getKey()).equals("nK2")) continue;
            Assert.assertEquals((Object)"VVV", entry.getValue());
            nK2Found = true;
        }
        Assert.assertTrue((String)"regular Key not found", (boolean)kFound);
        Assert.assertTrue((String)"deprecated Key not found", (boolean)dKFound);
        Assert.assertTrue((String)"new Key 1 not found", (boolean)nK1Found);
        Assert.assertTrue((String)"new Key 2 not found", (boolean)nK2Found);
    }
}

