/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.IOException;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestFileContextResolveAfs {
    private static String TEST_ROOT_DIR_LOCAL;
    private FileContext fc;
    private FileSystem localFs;

    @Before
    public void setup() throws IOException {
        this.fc = FileContext.getFileContext();
    }

    @Test(timeout=30000L)
    public void testFileContextResolveAfs() throws IOException {
        Configuration conf = new Configuration();
        this.localFs = FileSystem.get((Configuration)conf);
        Path localPath = new Path(TEST_ROOT_DIR_LOCAL + "/TestFileContextResolveAfs1");
        Path linkPath = this.localFs.makeQualified(new Path(TEST_ROOT_DIR_LOCAL, "TestFileContextResolveAfs2"));
        this.localFs.mkdirs(new Path(TEST_ROOT_DIR_LOCAL));
        this.localFs.create(localPath);
        this.fc.createSymlink(localPath, linkPath, true);
        Set afsList = this.fc.resolveAbstractFileSystems(linkPath);
        Assert.assertEquals((long)1L, (long)afsList.size());
        this.localFs.deleteOnExit(localPath);
        this.localFs.deleteOnExit(linkPath);
        this.localFs.close();
    }

    static {
        FileSystem.enableSymlinks();
        TEST_ROOT_DIR_LOCAL = GenericTestUtils.getTestDir().getAbsolutePath();
    }
}

