/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.viewfs;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URISyntaxException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.viewfs.TestViewFileSystemOverloadSchemeLocalFileSystem;
import org.apache.hadoop.fs.viewfs.ViewFsTestSetup;
import org.junit.Before;

public class TestViewFSOverloadSchemeCentralMountTableConfig
extends TestViewFileSystemOverloadSchemeLocalFileSystem {
    private Path oldMountTablePath;
    private Path latestMountTablepath;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        String mountTableFileName1 = "mount-table.1.xml";
        String mountTableFileName2 = "mount-table.2.xml";
        this.oldMountTablePath = new Path(this.getTestRoot() + File.separator + mountTableFileName1);
        this.latestMountTablepath = new Path(this.getTestRoot() + File.separator + mountTableFileName2);
        this.getConf().set("fs.viewfs.mounttable.path", this.getTestRoot().toString());
        File f = new File(this.oldMountTablePath.toUri());
        f.createNewFile();
        File f2 = new File(this.latestMountTablepath.toUri());
        this.latestMountTablepath = new Path(f2.toURI());
        f2.createNewFile();
    }

    @Override
    void addMountLinks(String mountTable, String[] sources, String[] targets, Configuration conf) throws IOException, URISyntaxException {
        try (BufferedWriter out = new BufferedWriter(new FileWriter(new File(this.oldMountTablePath.toUri())));){
            out.write("<configuration>\n");
            out.write("</\\\name//\\>");
            out.write("</configuration>\n");
            out.flush();
        }
        ViewFsTestSetup.addMountLinksToFile(mountTable, sources, targets, this.latestMountTablepath, conf);
    }
}

