/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparator;
import org.junit.Assert;
import org.junit.Test;

public class TestBooleanWritable {
    @Test
    public void testCompareUnequalWritables() throws Exception {
        DataOutputBuffer bTrue = this.writeWritable((Writable)new BooleanWritable(true));
        DataOutputBuffer bFalse = this.writeWritable((Writable)new BooleanWritable(false));
        WritableComparator writableComparator = WritableComparator.get(BooleanWritable.class);
        Assert.assertEquals((long)0L, (long)this.compare(writableComparator, bTrue, bTrue));
        Assert.assertEquals((long)0L, (long)this.compare(writableComparator, bFalse, bFalse));
        Assert.assertEquals((long)1L, (long)this.compare(writableComparator, bTrue, bFalse));
        Assert.assertEquals((long)-1L, (long)this.compare(writableComparator, bFalse, bTrue));
    }

    private int compare(WritableComparator writableComparator, DataOutputBuffer buf1, DataOutputBuffer buf2) {
        return writableComparator.compare(buf1.getData(), 0, buf1.size(), buf2.getData(), 0, buf2.size());
    }

    protected DataOutputBuffer writeWritable(Writable writable) throws IOException {
        DataOutputBuffer out = new DataOutputBuffer(1024);
        writable.write((DataOutput)out);
        out.flush();
        return out;
    }

    @Test
    public void testCommonMethods() {
        Assert.assertTrue((String)"testCommonMethods1 error !!!", (boolean)TestBooleanWritable.newInstance(true).equals((Object)TestBooleanWritable.newInstance(true)));
        Assert.assertTrue((String)"testCommonMethods2 error  !!!", (boolean)TestBooleanWritable.newInstance(false).equals((Object)TestBooleanWritable.newInstance(false)));
        Assert.assertFalse((String)"testCommonMethods3 error !!!", (boolean)TestBooleanWritable.newInstance(false).equals((Object)TestBooleanWritable.newInstance(true)));
        Assert.assertTrue((String)"testCommonMethods4 error !!!", (boolean)this.checkHashCode(TestBooleanWritable.newInstance(true), TestBooleanWritable.newInstance(true)));
        Assert.assertFalse((String)"testCommonMethods5 error !!! ", (boolean)this.checkHashCode(TestBooleanWritable.newInstance(true), TestBooleanWritable.newInstance(false)));
        Assert.assertTrue((String)"testCommonMethods6 error !!!", (TestBooleanWritable.newInstance(true).compareTo(TestBooleanWritable.newInstance(false)) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"testCommonMethods7 error !!!", (TestBooleanWritable.newInstance(false).compareTo(TestBooleanWritable.newInstance(true)) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"testCommonMethods8 error !!!", (TestBooleanWritable.newInstance(false).compareTo(TestBooleanWritable.newInstance(false)) == 0 ? 1 : 0) != 0);
        Assert.assertEquals((String)"testCommonMethods9 error !!!", (Object)"true", (Object)TestBooleanWritable.newInstance(true).toString());
    }

    private boolean checkHashCode(BooleanWritable f, BooleanWritable s) {
        return f.hashCode() == s.hashCode();
    }

    private static BooleanWritable newInstance(boolean flag) {
        return new BooleanWritable(flag);
    }
}

