/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.nativeio;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.commons.lang3.SystemUtils;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.io.nativeio.NativeIO;
import org.apache.hadoop.io.nativeio.SharedFileDescriptorFactory;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestSharedFileDescriptorFactory {
    static final Logger LOG = LoggerFactory.getLogger(TestSharedFileDescriptorFactory.class);
    private static final File TEST_BASE = GenericTestUtils.getTestDir();

    @Before
    public void setup() throws Exception {
        Assume.assumeTrue((null == SharedFileDescriptorFactory.getLoadingFailureReason() ? 1 : 0) != 0);
    }

    @Test(timeout=10000L)
    public void testReadAndWrite() throws Exception {
        File path = new File(TEST_BASE, "testReadAndWrite");
        path.mkdirs();
        SharedFileDescriptorFactory factory = SharedFileDescriptorFactory.create((String)"woot_", (String[])new String[]{path.getAbsolutePath()});
        FileInputStream inStream = factory.createDescriptor("testReadAndWrite", 4096);
        FileOutputStream outStream = new FileOutputStream(inStream.getFD());
        outStream.write(101);
        inStream.getChannel().position(0L);
        Assert.assertEquals((long)101L, (long)inStream.read());
        inStream.close();
        outStream.close();
        FileUtil.fullyDelete((File)path);
    }

    private static void createTempFile(String path) throws Exception {
        FileOutputStream fos = new FileOutputStream(path);
        fos.write(101);
        fos.close();
    }

    @Test(timeout=10000L)
    public void testCleanupRemainders() throws Exception {
        Assume.assumeTrue((boolean)NativeIO.isAvailable());
        Assume.assumeTrue((boolean)SystemUtils.IS_OS_UNIX);
        File path = new File(TEST_BASE, "testCleanupRemainders");
        path.mkdirs();
        String remainder1 = path.getAbsolutePath() + "/" + "woot2_remainder1";
        String remainder2 = path.getAbsolutePath() + "/" + "woot2_remainder2";
        TestSharedFileDescriptorFactory.createTempFile(remainder1);
        TestSharedFileDescriptorFactory.createTempFile(remainder2);
        SharedFileDescriptorFactory.create((String)"woot2_", (String[])new String[]{path.getAbsolutePath()});
        Assert.assertFalse((boolean)new File(remainder1).exists());
        Assert.assertFalse((boolean)new File(remainder2).exists());
        FileUtil.fullyDelete((File)path);
    }

    @Test(timeout=60000L)
    public void testDirectoryFallbacks() throws Exception {
        File nonExistentPath = new File(TEST_BASE, "nonexistent");
        File permissionDeniedPath = new File("/");
        File goodPath = new File(TEST_BASE, "testDirectoryFallbacks");
        goodPath.mkdirs();
        try {
            SharedFileDescriptorFactory.create((String)"shm_", (String[])new String[]{nonExistentPath.getAbsolutePath(), permissionDeniedPath.getAbsolutePath()});
            Assert.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        SharedFileDescriptorFactory factory = SharedFileDescriptorFactory.create((String)"shm_", (String[])new String[]{nonExistentPath.getAbsolutePath(), permissionDeniedPath.getAbsolutePath(), goodPath.getAbsolutePath()});
        Assert.assertEquals((Object)goodPath.getAbsolutePath(), (Object)factory.getPath());
        FileUtil.fullyDelete((File)goodPath);
    }
}

