/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.sink.ganglia;

import java.net.DatagramSocket;
import java.net.MulticastSocket;
import org.apache.commons.configuration2.SubsetConfiguration;
import org.apache.hadoop.metrics2.impl.ConfigBuilder;
import org.apache.hadoop.metrics2.sink.ganglia.GangliaSink30;
import org.junit.Assert;
import org.junit.Test;

public class TestGangliaSink {
    @Test
    public void testShouldCreateDatagramSocketByDefault() throws Exception {
        SubsetConfiguration conf = new ConfigBuilder().subset("test.sink.ganglia");
        GangliaSink30 gangliaSink = new GangliaSink30();
        gangliaSink.init(conf);
        DatagramSocket socket = gangliaSink.getDatagramSocket();
        Assert.assertFalse((String)"Did not create DatagramSocket", (socket == null || socket instanceof MulticastSocket ? 1 : 0) != 0);
    }

    @Test
    public void testShouldCreateDatagramSocketIfMulticastIsDisabled() throws Exception {
        SubsetConfiguration conf = new ConfigBuilder().add("test.sink.ganglia.multicast", false).subset("test.sink.ganglia");
        GangliaSink30 gangliaSink = new GangliaSink30();
        gangliaSink.init(conf);
        DatagramSocket socket = gangliaSink.getDatagramSocket();
        Assert.assertFalse((String)"Did not create DatagramSocket", (socket == null || socket instanceof MulticastSocket ? 1 : 0) != 0);
    }

    @Test
    public void testShouldCreateMulticastSocket() throws Exception {
        SubsetConfiguration conf = new ConfigBuilder().add("test.sink.ganglia.multicast", true).subset("test.sink.ganglia");
        GangliaSink30 gangliaSink = new GangliaSink30();
        gangliaSink.init(conf);
        DatagramSocket socket = gangliaSink.getDatagramSocket();
        Assert.assertTrue((String)"Did not create MulticastSocket", (socket != null && socket instanceof MulticastSocket ? 1 : 0) != 0);
        int ttl = ((MulticastSocket)socket).getTimeToLive();
        Assert.assertEquals((String)"Did not set default TTL", (long)1L, (long)ttl);
    }

    @Test
    public void testShouldSetMulticastSocketTtl() throws Exception {
        SubsetConfiguration conf = new ConfigBuilder().add("test.sink.ganglia.multicast", true).add("test.sink.ganglia.multicast.ttl", 3).subset("test.sink.ganglia");
        GangliaSink30 gangliaSink = new GangliaSink30();
        gangliaSink.init(conf);
        DatagramSocket socket = gangliaSink.getDatagramSocket();
        Assert.assertTrue((String)"Did not create MulticastSocket", (socket != null && socket instanceof MulticastSocket ? 1 : 0) != 0);
        int ttl = ((MulticastSocket)socket).getTimeToLive();
        Assert.assertEquals((String)"Did not set TTL", (long)3L, (long)ttl);
    }
}

