/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.naming.AuthenticationException;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.LdapGroupsMapping;
import org.apache.hadoop.security.TestLdapGroupsMappingBase;
import org.apache.hadoop.security.alias.CredentialProvider;
import org.apache.hadoop.security.alias.CredentialProviderFactory;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.thirdparty.com.google.common.collect.Iterators;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestLdapGroupsMappingWithBindUserSwitch
extends TestLdapGroupsMappingBase {
    private static final String TEST_USER_NAME = "some_user";

    @Test
    public void testIncorrectConfiguration() {
        Configuration conf = this.getBaseConf();
        conf.set("hadoop.security.group.mapping.ldap.bind.users", "user1,user2");
        conf.set("hadoop.security.group.mapping.ldap.bind.users.user1.bind.user", "bindUsername1");
        LdapGroupsMapping groupsMapping = new LdapGroupsMapping();
        try {
            groupsMapping.setConf(conf);
            groupsMapping.getGroups(TEST_USER_NAME);
            Assert.fail((String)"Should have failed with RuntimeException");
        }
        catch (RuntimeException e) {
            GenericTestUtils.assertExceptionContains("Bind username or password not configured for user: user2", e);
        }
    }

    @Test
    public void testBindUserSwitchPasswordPlaintext() throws Exception {
        Configuration conf = this.getBaseConf();
        conf.set("hadoop.security.group.mapping.ldap.bind.users", "user1,user2");
        conf.set("hadoop.security.group.mapping.ldap.bind.users.user1.bind.user", "bindUsername1");
        conf.set("hadoop.security.group.mapping.ldap.bind.users.user2.bind.user", "bindUsername2");
        conf.set("hadoop.security.group.mapping.ldap.bind.users.user1.bind.password", "bindPassword1");
        conf.set("hadoop.security.group.mapping.ldap.bind.users.user2.bind.password", "bindPassword2");
        this.doTestBindUserSwitch(conf, (Integer)1, Arrays.asList("bindUsername1", "bindUsername2"), Arrays.asList("bindPassword1", "bindPassword2"));
    }

    @Test
    public void testBindUserSwitchPasswordFromAlias() throws Exception {
        Configuration conf = this.getBaseConf();
        conf.set("hadoop.security.group.mapping.ldap.bind.users", "joe,lukas");
        conf.set("hadoop.security.group.mapping.ldap.bind.users.joe.bind.user", "joeBindUsername");
        conf.set("hadoop.security.group.mapping.ldap.bind.users.lukas.bind.user", "lukasBindUsername");
        conf.set("hadoop.security.group.mapping.ldap.bind.users.joe.bind.password.alias", "joeBindPasswordAlias");
        conf.set("hadoop.security.group.mapping.ldap.bind.users.lukas.bind.password.alias", "lukasBindPasswordAlias");
        this.setupCredentialProvider(conf);
        this.createCredentialForAlias(conf, "joeBindPasswordAlias", "joeBindPassword");
        this.createCredentialForAlias(conf, "lukasBindPasswordAlias", "lukasBindPassword");
        List<String> expectedBindUsers = Arrays.asList("joeBindUsername", "lukasBindUsername", "joeBindUsername");
        List<String> expectedBindPasswords = Arrays.asList("joeBindPassword", "lukasBindPassword", "joeBindPassword");
        this.doTestBindUserSwitch(conf, (Integer)2, expectedBindUsers, expectedBindPasswords);
    }

    @Test
    public void testBindUserSwitchPasswordFromFile() throws Exception {
        Configuration conf = this.getBaseConf();
        conf.setInt("hadoop.security.group.mapping.ldap.num.attempts", 10);
        conf.set("hadoop.security.group.mapping.ldap.bind.users", "bob,alice");
        conf.set("hadoop.security.group.mapping.ldap.bind.users.bob.bind.user", "bobUsername");
        conf.set("hadoop.security.group.mapping.ldap.bind.users.alice.bind.user", "aliceUsername");
        conf.set("hadoop.security.group.mapping.ldap.bind.users.bob.bind.password.file", this.createPasswordFile("bobPasswordFile1.txt", "bobBindPassword"));
        conf.set("hadoop.security.group.mapping.ldap.bind.users.alice.bind.password.file", this.createPasswordFile("alicePasswordFile2.txt", "aliceBindPassword"));
        List<String> expectedBindUsers = Arrays.asList("bobUsername", "aliceUsername", "bobUsername", "aliceUsername", "bobUsername");
        List<String> expectedBindPasswords = Arrays.asList("bobBindPassword", "aliceBindPassword", "bobBindPassword", "aliceBindPassword", "bobBindPassword");
        this.doTestBindUserSwitch(conf, (Integer)4, expectedBindUsers, expectedBindPasswords);
    }

    private void setupCredentialProvider(Configuration conf) {
        File testDir = GenericTestUtils.getTestDir();
        Path jksPath = new Path(testDir.toString(), "test.jks");
        String ourUrl = "jceks://file" + jksPath.toUri();
        File file = new File(testDir, "test.jks");
        file.delete();
        conf.set("hadoop.security.credential.provider.path", ourUrl);
    }

    private void createCredentialForAlias(Configuration conf, String alias, String password) throws Exception {
        CredentialProvider provider = (CredentialProvider)CredentialProviderFactory.getProviders((Configuration)conf).get(0);
        char[] bindpass = password.toCharArray();
        Assert.assertNull((Object)provider.getCredentialEntry(alias));
        provider.createCredentialEntry(alias, bindpass);
        provider.flush();
        Assert.assertArrayEquals((char[])bindpass, (char[])provider.getCredentialEntry(alias).getCredential());
    }

    private String createPasswordFile(String filename, String password) throws Exception {
        File testDir = GenericTestUtils.getTestDir();
        testDir.mkdirs();
        File secretFile = new File(testDir, filename);
        FileWriter writer = new FileWriter(secretFile);
        writer.write(password);
        ((Writer)writer).close();
        return secretFile.getPath();
    }

    private void doTestBindUserSwitch(Configuration conf, Integer numFailures, List<String> expectedBindUsers, List<String> expectedBindPasswords) throws NamingException {
        this.doTestBindUserSwitch(conf, numFailures, Iterators.cycle(expectedBindUsers), Iterators.cycle(expectedBindPasswords));
    }

    private void doTestBindUserSwitch(Configuration conf, Integer numFailures, Iterator<String> expectedBindUsers, Iterator<String> expectedBindPasswords) throws NamingException {
        TestLdapGroupsMappingBase.DummyLdapCtxFactory.setExpectedBindUser(expectedBindUsers.next());
        TestLdapGroupsMappingBase.DummyLdapCtxFactory.setExpectedBindPassword(expectedBindPasswords.next());
        AtomicInteger failuresLeft = new AtomicInteger(numFailures);
        Mockito.when(this.getContext().search(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), (Object[])ArgumentMatchers.any(Object[].class), (SearchControls)ArgumentMatchers.any(SearchControls.class))).thenAnswer(invocationOnMock -> {
            if (failuresLeft.get() > 0) {
                TestLdapGroupsMappingBase.DummyLdapCtxFactory.setExpectedBindUser((String)expectedBindUsers.next());
                TestLdapGroupsMappingBase.DummyLdapCtxFactory.setExpectedBindPassword((String)expectedBindPasswords.next());
                failuresLeft.decrementAndGet();
                throw new AuthenticationException();
            }
            if (failuresLeft.getAndDecrement() == 0) {
                return this.getUserNames();
            }
            return this.getGroupNames();
        });
        LdapGroupsMapping groupsMapping = new LdapGroupsMapping();
        groupsMapping.setConf(conf);
        List groups = groupsMapping.getGroups(TEST_USER_NAME);
        Assert.assertEquals(Arrays.asList("group1", "group2"), (Object)groups);
        int numExpectedSearchCalls = numFailures + 2;
        ((DirContext)Mockito.verify((Object)this.getContext(), (VerificationMode)Mockito.times((int)numExpectedSearchCalls))).search(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), (Object[])ArgumentMatchers.any(Object[].class), (SearchControls)ArgumentMatchers.any(SearchControls.class));
    }
}

