/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.service.launcher.testservices;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.AbstractService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunningService
extends AbstractService
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(RunningService.class);
    public static final String NAME = "org.apache.hadoop.service.launcher.testservices.RunningService";
    public static final int DELAY = 100;
    public static final String DELAY_TIME = "delay.time";
    public static final String FAIL_IN_RUN = "fail.runnable";
    public static final String FAILURE_MESSAGE = "FAIL_IN_RUN";
    private boolean interrupted;
    public int delayTime = 100;
    public boolean failInRun;

    public RunningService() {
        super("RunningService");
    }

    public RunningService(String name) {
        super(name);
    }

    protected void serviceInit(Configuration conf) throws Exception {
        super.serviceInit(conf);
        this.delayTime = this.getConfig().getInt(DELAY_TIME, this.delayTime);
        this.failInRun = this.getConfig().getBoolean(FAIL_IN_RUN, this.failInRun);
    }

    protected void serviceStart() throws Exception {
        Thread thread = new Thread(this);
        thread.setName(this.getName());
        thread.start();
    }

    @Override
    public void run() {
        try {
            Thread.sleep(this.delayTime);
            if (this.failInRun) {
                this.noteFailure(new Exception(FAILURE_MESSAGE));
            }
        }
        catch (InterruptedException e) {
            this.interrupted = true;
            LOG.info("Interrupted");
        }
        this.stop();
    }

    public boolean isInterrupted() {
        return this.interrupted;
    }
}

