/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.test;

import java.io.Closeable;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.stubbing.Stubber;

public abstract class MockitoUtil {
    public static <T> T mockProtocol(Class<T> clazz) {
        return (T)Mockito.mock(clazz, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{Closeable.class}));
    }

    public static Stubber doThrowWhenCallStackMatches(final Throwable t, final String pattern) {
        return Mockito.doAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                t.setStackTrace(Thread.currentThread().getStackTrace());
                for (StackTraceElement elem : t.getStackTrace()) {
                    if (!elem.toString().matches(pattern)) continue;
                    throw t;
                }
                return invocation.callRealMethod();
            }
        });
    }
}

