/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.nio.ByteBuffer;
import java.util.LinkedList;
import org.apache.hadoop.thirdparty.com.google.common.collect.Lists;
import org.apache.hadoop.util.DirectBufferPool;
import org.junit.Assert;
import org.junit.Test;

public class TestDirectBufferPool {
    final DirectBufferPool pool = new DirectBufferPool();

    @Test
    public void testBasics() {
        ByteBuffer a = this.pool.getBuffer(100);
        Assert.assertEquals((long)100L, (long)a.capacity());
        Assert.assertEquals((long)100L, (long)a.remaining());
        this.pool.returnBuffer(a);
        ByteBuffer b = this.pool.getBuffer(100);
        Assert.assertSame((Object)a, (Object)b);
        ByteBuffer c = this.pool.getBuffer(100);
        Assert.assertNotSame((Object)b, (Object)c);
        this.pool.returnBuffer(b);
        this.pool.returnBuffer(c);
    }

    @Test
    public void testBuffersAreReset() {
        ByteBuffer a = this.pool.getBuffer(100);
        a.putInt(-559038737);
        Assert.assertEquals((long)96L, (long)a.remaining());
        this.pool.returnBuffer(a);
        ByteBuffer b = this.pool.getBuffer(100);
        Assert.assertSame((Object)a, (Object)b);
        Assert.assertEquals((long)100L, (long)a.remaining());
        this.pool.returnBuffer(b);
    }

    @Test
    public void testWeakRefClearing() {
        LinkedList bufs = Lists.newLinkedList();
        for (int i = 0; i < 10; ++i) {
            ByteBuffer buf = this.pool.getBuffer(100);
            bufs.add(buf);
        }
        for (ByteBuffer buf : bufs) {
            this.pool.returnBuffer(buf);
        }
        Assert.assertEquals((long)10L, (long)this.pool.countBuffersOfSize(100));
        bufs.clear();
        bufs = null;
        for (int i = 0; i < 3; ++i) {
            System.gc();
        }
        ByteBuffer buf = this.pool.getBuffer(100);
        Assert.assertEquals((long)0L, (long)this.pool.countBuffersOfSize(100));
        this.pool.returnBuffer(buf);
    }
}

