/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.ReflectionUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestReflectionUtils {
    private static Class[] toConstruct = new Class[]{String.class, TestReflectionUtils.class, HashMap.class};
    private Throwable failure = null;

    @Before
    public void setUp() {
        ReflectionUtils.clearCache();
    }

    @Test
    public void testCache() throws Exception {
        Assert.assertEquals((long)0L, (long)this.cacheSize());
        this.doTestCache();
        Assert.assertEquals((long)toConstruct.length, (long)this.cacheSize());
        ReflectionUtils.clearCache();
        Assert.assertEquals((long)0L, (long)this.cacheSize());
    }

    private void doTestCache() {
        for (int i = 0; i < toConstruct.length; ++i) {
            Class cl = toConstruct[i];
            Object x = ReflectionUtils.newInstance((Class)cl, null);
            Object y = ReflectionUtils.newInstance((Class)cl, null);
            Assert.assertEquals((Object)cl, x.getClass());
            Assert.assertEquals((Object)cl, y.getClass());
        }
    }

    @Test
    public void testThreadSafe() throws Exception {
        int i;
        Thread[] th = new Thread[32];
        for (i = 0; i < th.length; ++i) {
            th[i] = new Thread(){

                @Override
                public void run() {
                    try {
                        TestReflectionUtils.this.doTestCache();
                    }
                    catch (Throwable t) {
                        TestReflectionUtils.this.failure = t;
                    }
                }
            };
            th[i].start();
        }
        for (i = 0; i < th.length; ++i) {
            th[i].join();
        }
        if (this.failure != null) {
            this.failure.printStackTrace();
            Assert.fail((String)this.failure.getMessage());
        }
    }

    private int cacheSize() throws Exception {
        return ReflectionUtils.getCacheSize();
    }

    @Test
    public void testCantCreate() {
        try {
            ReflectionUtils.newInstance(NoDefaultCtor.class, null);
            Assert.fail((String)"invalid call should fail");
        }
        catch (RuntimeException rte) {
            Assert.assertEquals(NoSuchMethodException.class, rte.getCause().getClass());
        }
    }

    @Test
    public void testCacheDoesntLeak() throws Exception {
        int iterations = 9999;
        for (int i = 0; i < iterations; ++i) {
            URLClassLoader loader = new URLClassLoader(new URL[0], this.getClass().getClassLoader());
            Class<?> cl = Class.forName("org.apache.hadoop.util.TestReflectionUtils$LoadedInChild", false, loader);
            Object o = ReflectionUtils.newInstance(cl, null);
            Assert.assertEquals(cl, o.getClass());
        }
        System.gc();
        Assert.assertTrue((String)(this.cacheSize() + " too big"), (this.cacheSize() < iterations ? 1 : 0) != 0);
    }

    @Test
    public void testGetDeclaredFieldsIncludingInherited() {
        Parent child = new Parent(){
            private int childField;

            public int getChildField() {
                return this.childField;
            }
        };
        List fields = ReflectionUtils.getDeclaredFieldsIncludingInherited(child.getClass());
        boolean containsParentField = false;
        boolean containsChildField = false;
        for (Field field : fields) {
            if (field.getName().equals("parentField")) {
                containsParentField = true;
                continue;
            }
            if (!field.getName().equals("childField")) continue;
            containsChildField = true;
        }
        List methods = ReflectionUtils.getDeclaredMethodsIncludingInherited(child.getClass());
        boolean containsParentMethod = false;
        boolean containsChildMethod = false;
        for (Method method : methods) {
            if (method.getName().equals("getParentField")) {
                containsParentMethod = true;
                continue;
            }
            if (!method.getName().equals("getChildField")) continue;
            containsChildMethod = true;
        }
        Assert.assertTrue((String)"Missing parent field", (boolean)containsParentField);
        Assert.assertTrue((String)"Missing child field", (boolean)containsChildField);
        Assert.assertTrue((String)"Missing parent method", (boolean)containsParentMethod);
        Assert.assertTrue((String)"Missing child method", (boolean)containsChildMethod);
    }

    @Test
    public void testLogThreadInfo() throws Exception {
        Logger logger = LoggerFactory.getLogger(TestReflectionUtils.class);
        GenericTestUtils.LogCapturer logCapturer = GenericTestUtils.LogCapturer.captureLogs(logger);
        String title = "title";
        ReflectionUtils.logThreadInfo((Logger)logger, (String)"title", (long)0L);
        Assert.assertThat((Object)logCapturer.getOutput(), (Matcher)CoreMatchers.containsString((String)"Process Thread Dump: title"));
    }

    public static class NoDefaultCtor {
        public NoDefaultCtor(int x) {
        }
    }

    private static class LoadedInChild {
        private LoadedInChild() {
        }
    }

    private class Parent {
        private int parentField;

        private Parent() {
        }

        public int getParentField() {
            return this.parentField;
        }
    }
}

