/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.jamon;

import org.apache.hadoop.hbase.shaded.org.jamon.AbstractTemplateManager;
import org.apache.hadoop.hbase.shaded.org.jamon.AbstractTemplateProxy;
import org.apache.hadoop.hbase.shaded.org.jamon.IdentityTemplateReplacer;
import org.apache.hadoop.hbase.shaded.org.jamon.TemplateManager;
import org.apache.hadoop.hbase.shaded.org.jamon.TemplateReplacer;

public class BasicTemplateManager
extends AbstractTemplateManager {
    private final ClassLoader classLoader;

    public BasicTemplateManager() {
        this((ClassLoader)null);
    }

    public BasicTemplateManager(ClassLoader classLoader) {
        this(classLoader, IdentityTemplateReplacer.INSTANCE);
    }

    public BasicTemplateManager(ClassLoader classLoader, TemplateReplacer templateReplacer) {
        super(templateReplacer);
        this.classLoader = classLoader == null ? this.getClass().getClassLoader() : classLoader;
    }

    @Override
    protected AbstractTemplateProxy.Intf constructImplFromReplacedProxy(AbstractTemplateProxy replacedProxy) {
        return replacedProxy.constructImpl();
    }

    @Override
    public AbstractTemplateProxy constructProxy(String path) {
        try {
            return this.getProxyClass(path).getConstructor(TemplateManager.class).newInstance(this);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("The template at path " + path + " could not be found");
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Class<? extends AbstractTemplateProxy> getProxyClass(String path) throws ClassNotFoundException {
        String strippedPath = BasicTemplateManager.stripLeadingSlashes(path);
        return this.classLoader.loadClass(strippedPath.replace('/', '.')).asSubclass(AbstractTemplateProxy.class);
    }

    private static String stripLeadingSlashes(String path) {
        int firstNonSlash;
        for (firstNonSlash = 0; path.indexOf(47, firstNonSlash) == firstNonSlash; ++firstNonSlash) {
        }
        return path.substring(firstNonSlash);
    }
}

