/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.thrift;

import org.apache.hadoop.hbase.metrics.ExceptionTrackingSourceImpl;
import org.apache.hadoop.hbase.thrift.MetricsThriftServerSource;
import org.apache.hadoop.metrics2.MetricHistogram;
import org.apache.hadoop.metrics2.lib.MutableFastCounter;
import org.apache.hadoop.metrics2.lib.MutableGaugeLong;
import org.apache.hadoop.metrics2.lib.MutableHistogram;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class MetricsThriftServerSourceImpl
extends ExceptionTrackingSourceImpl
implements MetricsThriftServerSource {
    private MetricHistogram batchGetStat;
    private MetricHistogram batchMutateStat;
    private MetricHistogram queueTimeStat;
    private MetricHistogram thriftCallStat;
    private MetricHistogram thriftSlowCallStat;
    private MutableGaugeLong callQueueLenGauge;
    private MutableGaugeLong activeWorkerCountGauge;
    private final MutableFastCounter infoPauseThresholdExceeded = this.getMetricsRegistry().newCounter("pauseInfoThresholdExceeded", "Count of INFO level pause threshold alerts", 0L);
    private final MutableFastCounter warnPauseThresholdExceeded = this.getMetricsRegistry().newCounter("pauseWarnThresholdExceeded", "Count of WARN level pause threshold alerts", 0L);
    private final MetricHistogram pausesWithGc = this.getMetricsRegistry().newTimeHistogram("pauseTimeWithGc");
    private final MetricHistogram pausesWithoutGc = this.getMetricsRegistry().newTimeHistogram("pauseTimeWithoutGc");

    public MetricsThriftServerSourceImpl(String metricsName, String metricsDescription, String metricsContext, String metricsJmxContext) {
        super(metricsName, metricsDescription, metricsContext, metricsJmxContext);
    }

    @Override
    public void init() {
        super.init();
        this.batchGetStat = this.getMetricsRegistry().newTimeHistogram("batchGet");
        this.batchMutateStat = this.getMetricsRegistry().newTimeHistogram("batchMutate");
        this.queueTimeStat = this.getMetricsRegistry().newTimeHistogram("timeInQueue");
        this.thriftCallStat = this.getMetricsRegistry().newTimeHistogram("thriftCall");
        this.thriftSlowCallStat = this.getMetricsRegistry().newTimeHistogram("slowThriftCall");
        this.callQueueLenGauge = this.getMetricsRegistry().getGauge("callQueueLen", 0L);
        this.activeWorkerCountGauge = this.getMetricsRegistry().getGauge("numActiveWorkers", 0L);
    }

    @Override
    public void incTimeInQueue(long time) {
        this.queueTimeStat.add(time);
    }

    @Override
    public void setCallQueueLen(int len) {
        this.callQueueLenGauge.set((long)len);
    }

    @Override
    public void incNumRowKeysInBatchGet(int diff) {
        this.batchGetStat.add(diff);
    }

    @Override
    public void incNumRowKeysInBatchMutate(int diff) {
        this.batchMutateStat.add(diff);
    }

    @Override
    public void incMethodTime(String name, long time) {
        MutableHistogram s2 = this.getMetricsRegistry().getHistogram(name);
        s2.add(time);
    }

    @Override
    public void incCall(long time) {
        this.thriftCallStat.add(time);
    }

    @Override
    public void incSlowCall(long time) {
        this.thriftSlowCallStat.add(time);
    }

    @Override
    public void incActiveWorkerCount() {
        this.activeWorkerCountGauge.incr();
    }

    @Override
    public void decActiveWorkerCount() {
        this.activeWorkerCountGauge.decr();
    }

    @Override
    public void incInfoThresholdExceeded(int count) {
        this.infoPauseThresholdExceeded.incr(count);
    }

    @Override
    public void incWarnThresholdExceeded(int count) {
        this.warnPauseThresholdExceeded.incr(count);
    }

    @Override
    public void updatePauseTimeWithGc(long t) {
        this.pausesWithGc.add(t);
    }

    @Override
    public void updatePauseTimeWithoutGc(long t) {
        this.pausesWithoutGc.add(t);
    }
}

