/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import org.apache.hadoop.hbase.util.Hash;
import org.apache.hadoop.hbase.util.HashKey;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Stable
public class MurmurHash3
extends Hash {
    private static MurmurHash3 _instance = new MurmurHash3();

    public static Hash getInstance() {
        return _instance;
    }

    @Override
    @SuppressWarnings(value={"SF"})
    public <T> int hash(HashKey<T> hashKey, int initval) {
        int c1 = -862048943;
        int c2 = 461845907;
        int length = hashKey.length();
        int h1 = initval;
        int roundedEnd = length & 0xFFFFFFFC;
        for (int i = 0; i < roundedEnd; i += 4) {
            int k1 = hashKey.get(i) & 0xFF | (hashKey.get(i + 1) & 0xFF) << 8 | (hashKey.get(i + 2) & 0xFF) << 16 | hashKey.get(i + 3) << 24;
            k1 *= -862048943;
            k1 = k1 << 15 | k1 >>> 17;
            h1 ^= (k1 *= 461845907);
            h1 = h1 << 13 | h1 >>> 19;
            h1 = h1 * 5 + -430675100;
        }
        int k1 = 0;
        switch (length & 3) {
            case 3: {
                k1 = (hashKey.get(roundedEnd + 2) & 0xFF) << 16;
            }
            case 2: {
                k1 |= (hashKey.get(roundedEnd + 1) & 0xFF) << 8;
            }
            case 1: {
                k1 |= hashKey.get(roundedEnd) & 0xFF;
                k1 *= -862048943;
                k1 = k1 << 15 | k1 >>> 17;
                h1 ^= (k1 *= 461845907);
            }
        }
        h1 ^= length;
        h1 ^= h1 >>> 16;
        h1 *= -2048144789;
        h1 ^= h1 >>> 13;
        h1 *= -1028477387;
        h1 ^= h1 >>> 16;
        return h1;
    }
}

