/*
 * Decompiled with CFR 0.152.
 */
package org.apache.htrace.core;

import java.io.Closeable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.htrace.core.HTraceConfiguration;
import org.apache.htrace.core.MilliSpan;
import org.apache.htrace.core.NullScope;
import org.apache.htrace.core.Sampler;
import org.apache.htrace.core.ScheduledTraceExecutorService;
import org.apache.htrace.core.Span;
import org.apache.htrace.core.SpanId;
import org.apache.htrace.core.SpanReceiver;
import org.apache.htrace.core.TraceCallable;
import org.apache.htrace.core.TraceExecutorService;
import org.apache.htrace.core.TraceRunnable;
import org.apache.htrace.core.TraceScope;
import org.apache.htrace.core.TracerId;
import org.apache.htrace.core.TracerPool;
import org.apache.htrace.shaded.commons.logging.Log;
import org.apache.htrace.shaded.commons.logging.LogFactory;

public class Tracer
implements Closeable {
    private static final Log LOG = LogFactory.getLog(Tracer.class);
    public static final String SPAN_RECEIVER_CLASSES_KEY = "span.receiver.classes";
    public static final String SAMPLER_CLASSES_KEY = "sampler.classes";
    static final ThreadLocal<TraceScope> threadLocalScope = new ThreadLocal();
    private static final SpanId[] EMPTY_PARENT_ARRAY = new SpanId[0];
    private final String tracerId;
    private TracerPool tracerPool;
    private final ThreadLocalContext threadContext;
    private final NullScope nullScope;
    private volatile Sampler[] curSamplers;

    static void throwClientError(String str) {
        LOG.error(str);
        throw new RuntimeException(str);
    }

    public static Tracer curThreadTracer() {
        TraceScope traceScope = threadLocalScope.get();
        if (traceScope == null) {
            return null;
        }
        return traceScope.tracer;
    }

    Tracer(String tracerId, TracerPool tracerPool, Sampler[] curSamplers) {
        this.tracerId = tracerId;
        this.tracerPool = tracerPool;
        this.threadContext = new ThreadLocalContext();
        this.nullScope = new NullScope(this);
        this.curSamplers = curSamplers;
    }

    public String getTracerId() {
        return this.tracerId;
    }

    private TraceScope newScopeImpl(ThreadContext context, String description) {
        MilliSpan span = new MilliSpan.Builder().tracerId(this.tracerId).begin(System.currentTimeMillis()).description(description).parents(EMPTY_PARENT_ARRAY).spanId(SpanId.fromRandom()).build();
        return context.pushNewScope(this, span, null);
    }

    private TraceScope newScopeImpl(ThreadContext context, String description, TraceScope parentScope) {
        SpanId parentId = parentScope.getSpan().getSpanId();
        MilliSpan span = new MilliSpan.Builder().tracerId(this.tracerId).begin(System.currentTimeMillis()).description(description).parents(new SpanId[]{parentId}).spanId(parentId.newChildId()).build();
        return context.pushNewScope(this, span, parentScope);
    }

    private TraceScope newScopeImpl(ThreadContext context, String description, SpanId parentId) {
        MilliSpan span = new MilliSpan.Builder().tracerId(this.tracerId).begin(System.currentTimeMillis()).description(description).parents(new SpanId[]{parentId}).spanId(parentId.newChildId()).build();
        return context.pushNewScope(this, span, null);
    }

    private TraceScope newScopeImpl(ThreadContext context, String description, TraceScope parentScope, SpanId secondParentId) {
        SpanId parentId = parentScope.getSpan().getSpanId();
        MilliSpan span = new MilliSpan.Builder().tracerId(this.tracerId).begin(System.currentTimeMillis()).description(description).parents(new SpanId[]{parentId, secondParentId}).spanId(parentId.newChildId()).build();
        return context.pushNewScope(this, span, parentScope);
    }

    public TraceScope newScope(String description, SpanId parentId) {
        TraceScope parentScope = threadLocalScope.get();
        ThreadContext context = (ThreadContext)this.threadContext.get();
        if (parentScope != null) {
            if (parentId.isValid() && !parentId.equals(parentScope.getSpan().getSpanId())) {
                return this.newScopeImpl(context, description, parentScope, parentId);
            }
            return this.newScopeImpl(context, description, parentScope);
        }
        if (parentId.isValid()) {
            return this.newScopeImpl(context, description, parentId);
        }
        if (!context.isTopLevel()) {
            context.pushScope();
            return this.nullScope;
        }
        if (!this.sample()) {
            context.pushScope();
            return this.nullScope;
        }
        return this.newScopeImpl(context, description);
    }

    public TraceScope newScope(String description) {
        TraceScope parentScope = threadLocalScope.get();
        ThreadContext context = (ThreadContext)this.threadContext.get();
        if (parentScope != null) {
            return this.newScopeImpl(context, description, parentScope);
        }
        if (!context.isTopLevel()) {
            context.pushScope();
            return this.nullScope;
        }
        if (!this.sample()) {
            context.pushScope();
            return this.nullScope;
        }
        return this.newScopeImpl(context, description);
    }

    public TraceScope newNullScope() {
        ThreadContext context = (ThreadContext)this.threadContext.get();
        context.pushScope();
        return this.nullScope;
    }

    public <V> Callable<V> wrap(Callable<V> callable, String description) {
        TraceScope parentScope = threadLocalScope.get();
        if (parentScope == null) {
            return callable;
        }
        return new TraceCallable<V>(this, parentScope.getSpanId(), callable, description);
    }

    public Runnable wrap(Runnable runnable, String description) {
        TraceScope parentScope = threadLocalScope.get();
        if (parentScope == null) {
            return runnable;
        }
        return new TraceRunnable(this, parentScope, runnable, description);
    }

    public TraceExecutorService newTraceExecutorService(ExecutorService impl) {
        return this.newTraceExecutorService(impl, null);
    }

    public TraceExecutorService newTraceExecutorService(ExecutorService impl, String scopeName) {
        return new TraceExecutorService(this, scopeName, impl);
    }

    public ScheduledTraceExecutorService newTraceExecutorService(ScheduledExecutorService impl) {
        return this.newTraceExecutorService(impl, null);
    }

    public ScheduledTraceExecutorService newTraceExecutorService(ScheduledExecutorService impl, String scopeName) {
        return new ScheduledTraceExecutorService(this, scopeName, impl);
    }

    public TracerPool getTracerPool() {
        if (this.tracerPool == null) {
            Tracer.throwClientError(this.toString() + " is closed.");
        }
        return this.tracerPool;
    }

    <T, V> T createProxy(final T instance) {
        InvocationHandler handler = new InvocationHandler(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public Object invoke(Object obj, Method method, Object[] args) throws Throwable {
                try (TraceScope scope = Tracer.this.newScope(method.getName());){
                    Object object = method.invoke(instance, args);
                    return object;
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                    throw ex;
                }
            }
        };
        return (T)Proxy.newProxyInstance(instance.getClass().getClassLoader(), instance.getClass().getInterfaces(), handler);
    }

    private boolean sample() {
        Sampler[] samplers;
        for (Sampler sampler : samplers = this.curSamplers) {
            if (!sampler.next()) continue;
            return true;
        }
        return false;
    }

    public Sampler[] getSamplers() {
        return this.curSamplers;
    }

    public synchronized boolean addSampler(Sampler sampler) {
        if (this.tracerPool == null) {
            Tracer.throwClientError(this.toString() + " is closed.");
        }
        Sampler[] samplers = this.curSamplers;
        for (int i = 0; i < samplers.length; ++i) {
            if (samplers[i] != sampler) continue;
            return false;
        }
        Sampler[] newSamplers = Arrays.copyOf(samplers, samplers.length + 1);
        newSamplers[samplers.length] = sampler;
        this.curSamplers = newSamplers;
        return true;
    }

    public synchronized boolean removeSampler(Sampler sampler) {
        if (this.tracerPool == null) {
            Tracer.throwClientError(this.toString() + " is closed.");
        }
        Sampler[] samplers = this.curSamplers;
        for (int i = 0; i < samplers.length; ++i) {
            if (samplers[i] != sampler) continue;
            Sampler[] newSamplers = new Sampler[samplers.length - 1];
            System.arraycopy(samplers, 0, newSamplers, 0, i);
            System.arraycopy(samplers, i + 1, newSamplers, i, samplers.length - i - 1);
            this.curSamplers = newSamplers;
            return true;
        }
        return false;
    }

    void detachScope(TraceScope scope) {
        TraceScope curScope = threadLocalScope.get();
        if (curScope != scope) {
            Tracer.throwClientError("Can't detach TraceScope for " + scope.getSpan().toJson() + " because it is not the current " + "TraceScope in thread " + Thread.currentThread().getName());
        }
        ThreadContext context = (ThreadContext)this.threadContext.get();
        context.popScope();
        threadLocalScope.set(scope.getParent());
    }

    void reattachScope(TraceScope scope) {
        TraceScope parent = threadLocalScope.get();
        threadLocalScope.set(scope);
        ThreadContext context = (ThreadContext)this.threadContext.get();
        context.pushScope();
        scope.setParent(parent);
    }

    void closeScope(TraceScope scope) {
        SpanReceiver[] receivers;
        TraceScope curScope = threadLocalScope.get();
        if (curScope != scope) {
            Tracer.throwClientError("Can't close TraceScope for " + scope.getSpan().toJson() + " because it is not the current " + "TraceScope in thread " + Thread.currentThread().getName());
        }
        if (this.tracerPool == null) {
            Tracer.throwClientError(this.toString() + " is closed.");
        }
        if ((receivers = this.tracerPool.getReceivers()) == null) {
            Tracer.throwClientError(this.toString() + " is closed.");
        }
        ThreadContext context = (ThreadContext)this.threadContext.get();
        context.popScope();
        threadLocalScope.set(scope.getParent());
        scope.setParent(null);
        Span span = scope.getSpan();
        span.stop();
        for (SpanReceiver receiver : receivers) {
            receiver.receiveSpan(span);
        }
    }

    void popNullScope() {
        TraceScope curScope = threadLocalScope.get();
        if (curScope != null) {
            Tracer.throwClientError("Attempted to close an empty scope, but it was not the current thread scope in thread " + Thread.currentThread().getName());
        }
        ThreadContext context = (ThreadContext)this.threadContext.get();
        context.popScope();
    }

    public static Span getCurrentSpan() {
        TraceScope curScope = threadLocalScope.get();
        if (curScope == null) {
            return null;
        }
        return curScope.getSpan();
    }

    public static SpanId getCurrentSpanId() {
        TraceScope curScope = threadLocalScope.get();
        if (curScope == null) {
            return SpanId.INVALID;
        }
        return curScope.getSpan().getSpanId();
    }

    @Override
    public synchronized void close() {
        if (this.tracerPool == null) {
            return;
        }
        this.curSamplers = new Sampler[0];
        this.tracerPool.removeTracer(this);
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    public boolean equals(Object other) {
        return this == other;
    }

    public String toString() {
        return "Tracer(" + this.tracerId + ")";
    }

    private static class ThreadLocalContext
    extends ThreadLocal<ThreadContext> {
        private ThreadLocalContext() {
        }

        @Override
        protected ThreadContext initialValue() {
            return new ThreadContext();
        }
    }

    private static class ThreadContext {
        private long depth = 0L;

        ThreadContext() {
        }

        boolean isTopLevel() {
            return this.depth == 0L;
        }

        void pushScope() {
            ++this.depth;
        }

        TraceScope pushNewScope(Tracer tracer, Span span, TraceScope parentScope) {
            TraceScope scope = new TraceScope(tracer, span, parentScope);
            threadLocalScope.set(scope);
            ++this.depth;
            return scope;
        }

        void popScope() {
            if (this.depth <= 0L) {
                Tracer.throwClientError("There were more trace scopes closed than were opened.");
            }
            --this.depth;
        }
    }

    public static class Builder {
        private String name;
        private HTraceConfiguration conf = HTraceConfiguration.EMPTY;
        private ClassLoader classLoader = Builder.class.getClassLoader();
        private TracerPool tracerPool = TracerPool.GLOBAL;

        @Deprecated
        public Builder() {
        }

        public Builder(String name) {
            this.name(name);
        }

        @Deprecated
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder conf(HTraceConfiguration conf) {
            this.conf = conf;
            return this;
        }

        public Builder tracerPool(TracerPool tracerPool) {
            this.tracerPool = tracerPool;
            return this;
        }

        private void loadSamplers(List<Sampler> samplers) {
            String classNamesStr = this.conf.get(Tracer.SAMPLER_CLASSES_KEY, "");
            List<String> classNames = this.getClassNamesFromConf(classNamesStr);
            StringBuilder bld = new StringBuilder();
            String prefix = "";
            for (String className : classNames) {
                try {
                    Sampler sampler = new Sampler.Builder(this.conf).className(className).classLoader(this.classLoader).build();
                    samplers.add(sampler);
                    bld.append(prefix).append(className);
                    prefix = ", ";
                }
                catch (Throwable e) {
                    LOG.error("Failed to create Sampler of type " + className, e);
                }
            }
            String resultString = bld.toString();
            if (resultString.isEmpty()) {
                resultString = "no samplers";
            }
            LOG.debug("sampler.classes = " + classNamesStr + "; loaded " + resultString);
        }

        private void loadSpanReceivers() {
            String classNamesStr = this.conf.get(Tracer.SPAN_RECEIVER_CLASSES_KEY, "");
            List<String> classNames = this.getClassNamesFromConf(classNamesStr);
            StringBuilder bld = new StringBuilder();
            String prefix = "";
            for (String className : classNames) {
                try {
                    this.tracerPool.loadReceiverType(className, this.conf, this.classLoader);
                    bld.append(prefix).append(className);
                    prefix = ", ";
                }
                catch (Throwable e) {
                    LOG.error("Failed to create SpanReceiver of type " + className, e);
                }
            }
            String resultString = bld.toString();
            if (resultString.isEmpty()) {
                resultString = "no span receivers";
            }
            LOG.debug("span.receiver.classes = " + classNamesStr + "; loaded " + resultString);
        }

        private List<String> getClassNamesFromConf(String classNamesStr) {
            String[] classNames = classNamesStr.split(";");
            LinkedList<String> cleanedClassNames = new LinkedList<String>();
            for (String className : classNames) {
                String cleanedClassName = className.trim();
                if (cleanedClassName.isEmpty()) continue;
                cleanedClassNames.add(cleanedClassName);
            }
            return cleanedClassNames;
        }

        public Tracer build() {
            if (this.name == null) {
                throw new RuntimeException("You must specify a name for this Tracer.");
            }
            LinkedList<Sampler> samplers = new LinkedList<Sampler>();
            this.loadSamplers(samplers);
            String tracerId = new TracerId(this.conf, this.name).get();
            Tracer tracer = new Tracer(tracerId, this.tracerPool, samplers.toArray(new Sampler[samplers.size()]));
            this.tracerPool.addTracer(tracer);
            this.loadSpanReceivers();
            if (LOG.isTraceEnabled()) {
                LOG.trace("Created " + tracer + " for " + this.name);
            }
            return tracer;
        }
    }
}

