/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.lib;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.HadoopTestCase;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapred.TextOutputFormat;
import org.apache.hadoop.mapred.Utils;
import org.apache.hadoop.mapred.lib.IdentityReducer;
import org.apache.hadoop.mapred.lib.InverseMapper;
import org.apache.hadoop.mapred.lib.KeyFieldBasedComparator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class TestKeyFieldBasedComparator
extends HadoopTestCase {
    private static final File TEST_DIR = new File(System.getProperty("test.build.data", System.getProperty("java.io.tmpdir")), "TestKeyFieldBasedComparator-lib");
    JobConf conf;
    JobConf localConf;
    String line1 = "123 -123 005120 123.9 0.01 0.18 010 10.0 4444.1 011 011 234";
    String line2 = "134 -12 005100 123.10 -1.01 0.19 02 10.1 4444";
    byte[] line1_bytes = this.line1.getBytes();
    byte[] line2_bytes = this.line2.getBytes();

    public TestKeyFieldBasedComparator() throws IOException {
        super(1, 4, 1, 1);
        this.conf = this.createJobConf();
        this.localConf = this.createJobConf();
        this.localConf.set("mapreduce.map.output.key.field.separator", " ");
    }

    public void configure(String keySpec, int expect) throws Exception {
        Path[] outputFiles;
        Path testdir = new Path(TEST_DIR.getAbsolutePath());
        Path inDir = new Path(testdir, "in");
        Path outDir = new Path(testdir, "out");
        FileSystem fs = this.getFileSystem();
        fs.delete(testdir, true);
        this.conf.setInputFormat(TextInputFormat.class);
        FileInputFormat.setInputPaths((JobConf)this.conf, (Path[])new Path[]{inDir});
        FileOutputFormat.setOutputPath((JobConf)this.conf, (Path)outDir);
        this.conf.setOutputKeyClass(Text.class);
        this.conf.setOutputValueClass(LongWritable.class);
        this.conf.setNumMapTasks(1);
        this.conf.setNumReduceTasks(1);
        this.conf.setOutputFormat(TextOutputFormat.class);
        this.conf.setOutputKeyComparatorClass(KeyFieldBasedComparator.class);
        this.conf.setKeyFieldComparatorOptions(keySpec);
        this.conf.setKeyFieldPartitionerOptions("-k1.1,1.1");
        this.conf.set("mapreduce.map.output.key.field.separator", " ");
        this.conf.setMapperClass(InverseMapper.class);
        this.conf.setReducerClass(IdentityReducer.class);
        if (!fs.mkdirs(testdir)) {
            throw new IOException("Mkdirs failed to create " + testdir.toString());
        }
        if (!fs.mkdirs(inDir)) {
            throw new IOException("Mkdirs failed to create " + inDir.toString());
        }
        Path inFile = new Path(inDir, "part0");
        FileOutputStream fos = new FileOutputStream(inFile.toString());
        fos.write((this.line1 + "\n").getBytes());
        fos.write((this.line2 + "\n").getBytes());
        fos.close();
        JobClient jc = new JobClient(this.conf);
        RunningJob r_job = jc.submitJob(this.conf);
        while (!r_job.isComplete()) {
            Thread.sleep(1000L);
        }
        if (!r_job.isSuccessful()) {
            Assert.fail((String)"Oops! The job broke due to an unexpected error");
        }
        if ((outputFiles = FileUtil.stat2Paths((FileStatus[])this.getFileSystem().listStatus(outDir, (PathFilter)new Utils.OutputFileUtils.OutputFilesFilter()))).length > 0) {
            FSDataInputStream is = this.getFileSystem().open(outputFiles[0]);
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)is));
            String line = reader.readLine();
            if (expect == 1) {
                Assert.assertTrue((boolean)line.startsWith(this.line1));
            } else if (expect == 2) {
                Assert.assertTrue((boolean)line.startsWith(this.line2));
            }
            line = reader.readLine();
            if (expect == 1) {
                Assert.assertTrue((boolean)line.startsWith(this.line2));
            } else if (expect == 2) {
                Assert.assertTrue((boolean)line.startsWith(this.line1));
            }
            reader.close();
        }
    }

    @After
    public void cleanup() {
        FileUtil.fullyDelete((File)TEST_DIR);
    }

    @Test
    public void testBasicUnixComparator() throws Exception {
        this.configure("-k1,1n", 1);
        this.configure("-k2,2n", 1);
        this.configure("-k2.2,2n", 2);
        this.configure("-k3.4,3n", 2);
        this.configure("-k3.2,3.3n -k4,4n", 2);
        this.configure("-k3.2,3.3n -k4,4nr", 1);
        this.configure("-k2.4,2.4n", 2);
        this.configure("-k7,7", 1);
        this.configure("-k7,7n", 2);
        this.configure("-k8,8n", 1);
        this.configure("-k9,9", 2);
        this.configure("-k11,11", 2);
        this.configure("-k10,10", 2);
        this.localTestWithoutMRJob("-k9,9", 1);
    }

    public void localTestWithoutMRJob(String keySpec, int expect) throws Exception {
        KeyFieldBasedComparator keyFieldCmp = new KeyFieldBasedComparator();
        this.localConf.setKeyFieldComparatorOptions(keySpec);
        keyFieldCmp.configure(this.localConf);
        int result = keyFieldCmp.compare(this.line1_bytes, 0, this.line1_bytes.length, this.line2_bytes, 0, this.line2_bytes.length);
        if (expect >= 0 && result < 0 || expect < 0 && result >= 0) {
            Assert.fail();
        }
    }
}

