/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.security;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MiniMRClientCluster;
import org.apache.hadoop.mapred.MiniMRClientClusterFactory;
import org.apache.hadoop.mapreduce.security.CredentialsTestJob;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestMRCredentials {
    static final int NUM_OF_KEYS = 10;
    private static MiniMRClientCluster mrCluster;
    private static MiniDFSCluster dfsCluster;
    private static int numWorkers;
    private static JobConf jConf;

    @BeforeClass
    public static void setUp() throws Exception {
        System.setProperty("hadoop.log.dir", "logs");
        Configuration conf = new Configuration();
        dfsCluster = new MiniDFSCluster.Builder(conf).numDataNodes(numWorkers).build();
        jConf = new JobConf(conf);
        FileSystem.setDefaultUri((Configuration)conf, (String)dfsCluster.getFileSystem().getUri().toString());
        mrCluster = MiniMRClientClusterFactory.create(TestMRCredentials.class, 1, (Configuration)jConf);
        TestMRCredentials.createKeysAsJson("keys.json");
    }

    @AfterClass
    public static void tearDown() throws Exception {
        if (mrCluster != null) {
            mrCluster.stop();
        }
        mrCluster = null;
        if (dfsCluster != null) {
            dfsCluster.shutdown();
        }
        dfsCluster = null;
        new File("keys.json").delete();
    }

    public static void createKeysAsJson(String fileName) throws FileNotFoundException, IOException {
        StringBuilder jsonString = new StringBuilder();
        jsonString.append("{");
        for (int i = 0; i < 10; ++i) {
            String keyName = "alias" + i;
            String password = "password" + i;
            jsonString.append("\"" + keyName + "\":\"" + password + "\"");
            if (i >= 9) continue;
            jsonString.append(",");
        }
        jsonString.append("}");
        FileOutputStream fos = new FileOutputStream(fileName);
        fos.write(jsonString.toString().getBytes());
        fos.close();
    }

    @Test
    public void test() throws IOException {
        JobConf jobConf = new JobConf(mrCluster.getConfig());
        NameNode nn = dfsCluster.getNameNode();
        URI nnUri = DFSUtilClient.getNNUri((InetSocketAddress)nn.getNameNodeAddress());
        jobConf.set("mapreduce.job.hdfs-servers", nnUri + "," + nnUri.toString());
        jobConf.set("mapreduce.job.credentials.json", "keys.json");
        String[] args = new String[]{"-m", "1", "-r", "1", "-mt", "1", "-rt", "1"};
        int res = -1;
        try {
            res = ToolRunner.run((Configuration)jobConf, (Tool)new CredentialsTestJob(), (String[])args);
        }
        catch (Exception e) {
            System.out.println("Job failed with" + e.getLocalizedMessage());
            e.printStackTrace(System.out);
            Assert.fail((String)"Job failed");
        }
        ((AbstractIntegerAssert)Assertions.assertThat((int)res).withFailMessage("dist job res is not 0", new Object[0])).isEqualTo(0);
    }

    static {
        numWorkers = 1;
    }
}

